package fr.emac.gind.modeler.ioda;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.w3c.dom.Element;

import com.google.common.collect.ImmutableMap;

import fr.emac.gind.commons.utils.crypt.AES;
import fr.emac.gind.commons.utils.crypt.MD5;
import fr.emac.gind.commons.utils.cxf.CXFServerHelper;
import fr.emac.gind.commons.utils.cxf.Server;
import fr.emac.gind.commons.utils.jaxb.SOAException;
import fr.emac.gind.generic.application.EmbeddedMongoDb;
import fr.emac.gind.generic.application.bundles.modifier.ExternalModifierResource;
import fr.emac.gind.gov.ontology_gov.GJaxbCreateOntologyFromMM;
import fr.emac.gind.gov.ontology_gov.GJaxbCreateOntologyFromMMResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbDeduceProcess;
import fr.emac.gind.gov.ontology_gov.GJaxbDeduceProcessResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbFindOntologyByQName;
import fr.emac.gind.gov.ontology_gov.GJaxbFindOntologyByQNameResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbGetDifferentInstancesOfConcepts;
import fr.emac.gind.gov.ontology_gov.GJaxbGetDifferentInstancesOfConceptsResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbGetInstancesOfConcept;
import fr.emac.gind.gov.ontology_gov.GJaxbGetInstancesOfConceptResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbGetNearInstancesOfConcepts;
import fr.emac.gind.gov.ontology_gov.GJaxbGetNearInstancesOfConceptsResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbGetOntology;
import fr.emac.gind.gov.ontology_gov.GJaxbGetOntologyResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbGetSameAsInstancesOfConcepts;
import fr.emac.gind.gov.ontology_gov.GJaxbGetSameAsInstancesOfConceptsResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbInstance;
import fr.emac.gind.gov.ontology_gov.GJaxbLinkType;
import fr.emac.gind.gov.ontology_gov.GJaxbPopulateOntologyFromDOM;
import fr.emac.gind.gov.ontology_gov.GJaxbPopulateOntologyFromDOMResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbPopulateOntologyFromURL;
import fr.emac.gind.gov.ontology_gov.GJaxbPopulateOntologyFromURLResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbPublishOntologyFromDOM;
import fr.emac.gind.gov.ontology_gov.GJaxbPublishOntologyFromDOMResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbPublishOntologyFromURL;
import fr.emac.gind.gov.ontology_gov.GJaxbPublishOntologyFromURLResponse;
import fr.emac.gind.gov.ontology_gov.GJaxbReportOnPopulate;
import fr.emac.gind.ioda.IodaCrisisTreatmentSystemService;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.SOAJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.storage.mongodb.StorageWebService;
import fr.emac.gind.users.backend.UsersManagerClient;
import fr.emac.gind.users.model.GJaxbRole;
import fr.emac.gind.users.model.GJaxbUser;
import fr.emac.gind.users.model.UserFactory;
import fr.gind.emac.gov.ontology_gov.FaultMessage;
import fr.gind.emac.gov.ontology_gov.OntologyGov;

/**
 * Unit test for simple App.
 */
public class IodaCrisisTreatmentSystemAppTest  {

	public static void main(String[] args) throws Exception {
		
    Server ontologyServer = CXFServerHelper.getService("http://localhost:8094/OntologyLinkService", OntologyGov.class, new OntologyGov() {

      @Override
      public GJaxbGetInstancesOfConceptResponse getInstancesOfConcept(
          GJaxbGetInstancesOfConcept parameters) throws FaultMessage {
        GJaxbGetInstancesOfConceptResponse response = new GJaxbGetInstancesOfConceptResponse();
        for(int i = 0; i < 100; i++) {
          GJaxbInstance instance = new GJaxbInstance();
          instance.setName("instanceConcept" + i);
          if(i % 2 == 0) {
            instance.getLink().add(GJaxbLinkType.NEAR);
          } else {
            instance.getLink().add(GJaxbLinkType.DIFFERENT);
          }
          response.getInstance().add(instance);
        }
        return response;
      }

      @Override
      public GJaxbGetNearInstancesOfConceptsResponse getNearInstancesOfConcepts(
          GJaxbGetNearInstancesOfConcepts parameters)
              throws FaultMessage {
        // TODO Auto-generated method stub
        return null;
      }

      @Override
      public GJaxbGetDifferentInstancesOfConceptsResponse getDifferentInstancesOfConcepts(
          GJaxbGetDifferentInstancesOfConcepts parameters)
              throws FaultMessage {
        // TODO Auto-generated method stub
        return null;
      }

      @Override
      public GJaxbGetSameAsInstancesOfConceptsResponse getSameAsInstancesOfConcepts(
          GJaxbGetSameAsInstancesOfConcepts parameters)
              throws FaultMessage {
        // TODO Auto-generated method stub
        return null;
      }

      @Override
      public GJaxbFindOntologyByQNameResponse findOntologyByQName(
          GJaxbFindOntologyByQName parameters) throws FaultMessage {
        // TODO Auto-generated method stub
        return null;
      }

      @Override
      public GJaxbCreateOntologyFromMMResponse createOntologyFromMM(
          GJaxbCreateOntologyFromMM parameters) throws FaultMessage {
        // TODO Auto-generated method stub
        return null;
      }

      @Override
      public GJaxbPublishOntologyFromURLResponse publishOntologyFromURL(
          GJaxbPublishOntologyFromURL parameters) throws FaultMessage {
        // TODO Auto-generated method stub
        return null;
      }

      @Override
      public GJaxbGetOntologyResponse getOntology(GJaxbGetOntology parameters)
          throws FaultMessage {
        // TODO Auto-generated method stub
        return null;
      }

      
      @Override
      public GJaxbPublishOntologyFromDOMResponse publishOntologyFromDOM(
          GJaxbPublishOntologyFromDOM parameters) throws FaultMessage {
        // TODO Auto-generated method stub
        return null;
      }

      

      @Override
      public GJaxbPopulateOntologyFromDOMResponse populateOntologyFromDOM(
          GJaxbPopulateOntologyFromDOM parameters) throws FaultMessage {
        GJaxbPopulateOntologyFromDOMResponse response = new GJaxbPopulateOntologyFromDOMResponse();

        System.out.println("populateOntology called");
        System.out.println(parameters.getAny());

        try {
          GJaxbGenericModel modelInstance = SOAJAXBContext.getInstance().unmarshallDocument(((Element)parameters.getAny()).getOwnerDocument(), GJaxbGenericModel.class);
          System.out.println("modelInstance = " + modelInstance);

          response.setReportOnPopulate(new GJaxbReportOnPopulate());
          response.getReportOnPopulate().setNumberOfInstancesAdded(5);
          response.getReportOnPopulate().setNumberOfInstancesAlreadyKnown(2);
        } catch (SOAException e) {
          throw new FaultMessage(e.getMessage(), e);
        }
        return response;
      }


      @Override
      public GJaxbPopulateOntologyFromURLResponse populateOntologyFromURL(
          GJaxbPopulateOntologyFromURL parameters) throws FaultMessage {
        // TODO Auto-generated method stub
        return null;
      }

      @Override
      public GJaxbDeduceProcessResponse deduceProcess(
          GJaxbDeduceProcess parameters) throws FaultMessage {
        String ontologyID = parameters.getOntologyID();
        
        // TODO: S. Truptil
        GJaxbGenericModel instance = new GJaxbGenericModel();
        instance.setTitle("instanceFrom_" + ontologyID);
        
        
        GJaxbDeduceProcessResponse response = new GJaxbDeduceProcessResponse();
        response.setOntologyID(ontologyID);
        try {
          response.setAny(SOAJAXBContext.getInstance().marshallAnyElement(instance).getDocumentElement());
        } catch (SOAException e) {
          e.printStackTrace();
          throw new FaultMessage(e.getMessage(), e);
        }
        return response;
      }



    });
    ontologyServer.start();

    ExternalModifierResource.RESOURCES_FOLDER = "./target/resourcesFolder";

		
		new EmbeddedMongoDb().start();
		StorageWebService wsStorage = new StorageWebService();
		wsStorage.start(new HashMap<String, Object>(){{put("host","localhost"); put("port",8083); put("serviceName","Storage"); put("database-name","gind"); put("database-host","localhost"); put("database-port",String.valueOf(EmbeddedMongoDb.DEFAULT_MONGODB_PORT)); }});

		UsersManagerClient client = new UsersManagerClient("users", "http://localhost:8083/Storage");
		client.putUser(UserFactory.getInstance().createUser("ken.addams@mines-albi.fr" , "Ken", "ADDAMS", MD5.cryptWithMD5("pwd"), "2014-02-24", "06.07.08.09.10", "05.81.82.83.84", "kaddams", "campus jalard", "81000", "Albi", new ArrayList<GJaxbRole>()));
		GJaxbUser user = client.putUser(UserFactory.getInstance().createUser("nicolas.salatge@gmail.com", "Nicolas", "SALATGE", MD5.cryptWithMD5("pwd"), "2014-02-24", "06.07.08.09.10", "05.81.82.83.84", "nsalatge", "campus jalard", "81000", "Albi", Arrays.asList(UserFactory.getInstance().createUserRole("administrator", true, true))));
		
		
		// For debug: add directly the authentication to context
		Map<String, Object> context = new HashMap<String, Object>();
		context.put("currentToken", new AES().encrypt("nicolas.salatge@gmail.com" + ":" + MD5.cryptWithMD5("pwd")));
		context.put("currentUser", user);
		
	
		IodaCrisisTreatmentSystemService modelerService = new IodaCrisisTreatmentSystemService(context);
		modelerService.boot(new Configuration(ImmutableMap.of(
				"application", "./src/main/resources/conf/Application.xml", 
				"metaModel",     "./src/main/resources/conf/MetaModel.xml", 
				"modelerCommandServicePort",  "8812",
				"storage",     "http://localhost:8083/Storage",
				"ontologyLink", "http://localhost:8094/OntologyLinkService")));
		modelerService.run(new String[]{ "server", new File("./src/main/resources/conf/config.yml").getCanonicalFile().toString() });
	}

}
