/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.packager;

import fr.emac.gind.packager.OSValidator;
import fr.emac.gind.packager.component.AbstractComponent;
import fr.emac.gind.packager.conf.ConfigManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPackager {
    private static Logger LOG = LoggerFactory.getLogger((String)AbstractPackager.class.getName());
    private static ServiceLoader<AbstractComponent> componentLoader = ServiceLoader.load(AbstractComponent.class);
    private List<AbstractComponent> components = new ArrayList<AbstractComponent>();
    private ConfigManager configManager = null;

    public void launch(String[] args) throws Exception {
        this.components = AbstractPackager.loadComponents();
        this.configManager = new ConfigManager(this.components);
    }

    public static List<AbstractComponent> loadComponents() {
        ArrayList<AbstractComponent> components = new ArrayList<AbstractComponent>();
        componentLoader.reload();
        for (AbstractComponent command : componentLoader) {
            LOG.info("Load component in class: " + command.getClass());
            components.add(command);
        }
        return components;
    }

    public List<AbstractComponent> getComponents() {
        return this.components;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public abstract String getName();

    public Map<AbstractComponent, Process> startAllComponents() throws Exception {
        HashMap<AbstractComponent, Process> processes = new HashMap<AbstractComponent, Process>();
        for (AbstractComponent comp : this.components) {
            processes.put(comp, this.startComponent(comp));
            Thread.sleep(4000L);
        }
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Process startComponent(AbstractComponent comp) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Object lock = new Object();
        Runner runner = null;
        runner = OSValidator.isWindows() ? new Runner(comp, comp.getStartupFiles().get((Object)AbstractComponent.OS.Win64), lock) : new Runner(comp, comp.getStartupFiles().get((Object)AbstractComponent.OS.Linux), lock);
        executor.execute(runner);
        Object object = lock;
        synchronized (object) {
            lock.wait();
        }
        return runner.getProcess();
    }

    private void writeInputStream(InputStream ips) throws IOException {
        String ligne;
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        while ((ligne = br.readLine()) != null) {
            System.out.flush();
        }
        br.close();
    }

    public Map<AbstractComponent, Process> stopComponents(Map<AbstractComponent, Process> activeProcesses) {
        HashMap<AbstractComponent, Process> unstableProcesses = new HashMap<AbstractComponent, Process>();
        if (activeProcesses != null) {
            for (Map.Entry<AbstractComponent, Process> entry : activeProcesses.entrySet()) {
                try {
                    this.stopComponent(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return unstableProcesses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopComponent(final AbstractComponent comp, final Process process) throws Exception {
        Object lock;
        LOG.info("stop component: " + comp.getName());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        if (comp.hasASpecificShutdownProcess()) {
            lock = new Object();
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        comp.runSpecificShutdownProcess();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        process.destroy();
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                }
            });
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        lock = new Object();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                process.destroy();
                try {
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            lock.wait();
        }
        if (comp.getLockFile() != null && ((File)(lock = new File(comp.getLockFile().toURI()))).exists()) {
            ((File)lock).delete();
        }
    }

    public class Runner
    implements Runnable {
        private AbstractComponent comp = null;
        private URL script = null;
        private Process process = null;
        private Object lock = null;

        public Runner(AbstractComponent comp, URL script, Object lock) {
            this.comp = comp;
            this.script = script;
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    if (this.script == null) break block7;
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    File binDirectory = new File(this.script.toURI()).getCanonicalFile().getParentFile();
                    List<String> commands = new ArrayList<String>();
                    if (OSValidator.isWindows()) {
                        commands.add("cmd.exe");
                        commands.add("/K");
                        commands.add("start");
                        commands.add("\"" + this.comp.getName() + "\"");
                        commands.add(new File(this.script.toURI()).getCanonicalFile().toString());
                        commands = this.addParams(this.comp, commands);
                    } else {
                        commands.add("gnome-terminal");
                        commands.add("--title");
                        commands.add("\"" + this.comp.getName() + "\"");
                        commands.add("--command");
                        commands.add(new File(this.script.toURI()).getCanonicalFile().toString());
                        commands.add(" " + this.addParamsInString(this.comp));
                    }
                    builder.command(commands);
                    builder.directory(binDirectory);
                    LOG.info("Start: " + builder.command());
                    this.process = builder.start();
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notify();
                    }
                    ExecutorService printer = Executors.newSingleThreadExecutor();
                    printer.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AbstractPackager.this.writeInputStream(Runner.this.process.getInputStream());
                                AbstractPackager.this.writeInputStream(Runner.this.process.getErrorStream());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    this.process.waitFor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private String addParamsInString(AbstractComponent comp) throws Exception {
            String res = " ";
            if (comp != null && comp.getStartupParams() != null) {
                for (AbstractComponent.Param p : comp.getStartupParams()) {
                    res = res + "\"" + p.getKey() + " " + p.getValue() + "\"";
                }
            }
            return res;
        }

        private List<String> addParams(AbstractComponent comp2, List<String> commands) throws Exception {
            if (this.comp.getStartupParams() == null || this.comp.getStartupParams().isEmpty()) {
                return commands;
            }
            ArrayList res = new ArrayList();
            for (AbstractComponent.Param p : this.comp.getStartupParams()) {
                commands.add(p.getKey());
                commands.add(p.getValue());
            }
            return commands;
        }

        public Process getProcess() {
            return this.process;
        }
    }
}

