/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.packager;

import fr.emac.gind.packager.AbstractPackager;
import fr.emac.gind.packager.swing.InstallerJFrame;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static Logger LOG = LoggerFactory.getLogger((String)Main.class.getName());
    private static ServiceLoader<AbstractPackager> installerLoader = ServiceLoader.load(AbstractPackager.class);
    private static List<AbstractPackager> installer = new ArrayList<AbstractPackager>();

    public static void main(String[] args) throws Exception {
        installer.clear();
        installerLoader.reload();
        for (AbstractPackager command : installerLoader) {
            LOG.info("Load installer in class: " + command.getClass());
            installer.add(command);
        }
        assert (installer.size() != 0) : "No installer found";
        assert (installer.size() == 1) : "Several installers found";
        final AbstractPackager launcher = installer.get(0);
        launcher.launch(args);
        Main.initLookAndFeel();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new InstallerJFrame(launcher).setVisible(true);
            }
        });
    }

    public static void initLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception ex) {
            LOG.error(null, (Throwable)ex);
        }
    }
}

