/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.packager.conf;

import fr.emac.gind.packager.component.AbstractComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfigManager {
    private Map<AbstractComponent, Properties> confmap = new HashMap<AbstractComponent, Properties>();

    public ConfigManager(List<AbstractComponent> components) throws Exception {
        for (AbstractComponent comp : components) {
            Properties props = new Properties();
            if (comp.getConfigurationFile() == null) continue;
            props.load(new FileInputStream(new File(comp.getConfigurationFile().toURI())));
            this.confmap.put(comp, props);
        }
    }

    public Properties getProperties(AbstractComponent component) {
        return this.confmap.get(component);
    }

    public void save() throws Exception {
        for (Map.Entry<AbstractComponent, Properties> props : this.confmap.entrySet()) {
            props.getValue().store(new FileOutputStream(new File(props.getKey().getConfigurationFile().toURI())), null);
        }
    }
}

