/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.packager.swing;

import fr.emac.gind.packager.AbstractPackager;
import fr.emac.gind.packager.component.AbstractComponent;
import fr.emac.gind.packager.swing.ShowConfigurationJFrame;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class InstallerJFrame
extends JFrame {
    private AbstractPackager installer;
    private Map<AbstractComponent, Process> activeProcesses = null;
    private JButton jButtonClose;
    private JButton jButtonShowGlobalConfiguration;
    private JButton jButtonStartAllComponents;
    private JButton jButtonStopAllComponents;
    private JLabel jLabelInstaller;
    private JLabel jLabelWelCome;
    private JPanel jPanelMain;
    private JScrollPane jScrollPane;
    private JSeparator jSeparatorMain;

    public InstallerJFrame(AbstractPackager installer) {
        this.initComponents();
        this.installer = installer;
        this.jLabelInstaller.setText(this.installer.getName());
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jPanelMain = new JPanel();
        this.jLabelWelCome = new JLabel();
        this.jLabelInstaller = new JLabel();
        this.jButtonStartAllComponents = new JButton();
        this.jButtonShowGlobalConfiguration = new JButton();
        this.jButtonStopAllComponents = new JButton();
        this.jButtonClose = new JButton();
        this.jSeparatorMain = new JSeparator();
        this.setDefaultCloseOperation(3);
        this.setTitle("Installer");
        this.jLabelWelCome.setFont(new Font("Tahoma", 2, 14));
        this.jLabelWelCome.setHorizontalAlignment(0);
        this.jLabelWelCome.setText("Welcome to:");
        this.jLabelInstaller.setFont(new Font("Tahoma", 1, 18));
        this.jLabelInstaller.setHorizontalAlignment(0);
        this.jLabelInstaller.setText("jLabel2");
        this.jButtonStartAllComponents.setText("Start All Components");
        this.jButtonStartAllComponents.setHorizontalTextPosition(0);
        this.jButtonStartAllComponents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerJFrame.this.jButtonStartAllComponentsActionPerformed(evt);
            }
        });
        this.jButtonShowGlobalConfiguration.setText("Show Global Configuration");
        this.jButtonShowGlobalConfiguration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerJFrame.this.jButtonShowGlobalConfigurationActionPerformed(evt);
            }
        });
        this.jButtonStopAllComponents.setText("Stop All Components");
        this.jButtonStopAllComponents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerJFrame.this.jButtonStopAllComponentsActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerJFrame.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelInstaller, -1, -1, Short.MAX_VALUE).addGroup(jPanelMainLayout.createSequentialGroup().addGap(157, 157, 157).addComponent(this.jButtonClose, -1, 100, Short.MAX_VALUE).addGap(135, 135, 135)).addGroup(jPanelMainLayout.createSequentialGroup().addGap(85, 85, 85).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonStopAllComponents, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonStartAllComponents, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonShowGlobalConfiguration, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addGap(66, 66, 66)).addGroup(jPanelMainLayout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.jLabelWelCome, -2, 157, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparatorMain).addContainerGap()));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jLabelWelCome, -2, 37, -2).addGap(18, 18, 18).addComponent(this.jLabelInstaller).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 66, Short.MAX_VALUE).addComponent(this.jButtonStartAllComponents).addGap(18, 18, 18).addComponent(this.jButtonShowGlobalConfiguration).addGap(23, 23, 23).addComponent(this.jSeparatorMain, -2, -1, -2).addGap(14, 14, 14).addComponent(this.jButtonStopAllComponents).addGap(18, 18, 18).addComponent(this.jButtonClose).addGap(54, 54, 54)));
        this.jScrollPane.setViewportView(this.jPanelMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonStopAllComponentsActionPerformed(ActionEvent evt) {
        try {
            this.activeProcesses = this.installer.stopComponents(this.activeProcesses);
            for (AbstractComponent comp : this.installer.getComponents()) {
                File lock;
                if (comp.getLockFile() == null || !(lock = new File(comp.getLockFile().toURI())).exists()) continue;
                lock.delete();
            }
            this.jButtonStartAllComponents.setEnabled(true);
            this.jButtonShowGlobalConfiguration.setEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error to stop all components", 0);
        }
    }

    private void jButtonShowGlobalConfigurationActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ShowConfigurationJFrame(InstallerJFrame.this.installer).setVisible(true);
            }
        });
    }

    private void jButtonStartAllComponentsActionPerformed(ActionEvent evt) {
        this.jButtonStartAllComponents.setEnabled(false);
        this.jButtonShowGlobalConfiguration.setEnabled(false);
        try {
            this.activeProcesses = this.installer.startAllComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error to start all components", 0);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(InstallerJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(InstallerJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(InstallerJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(InstallerJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new InstallerJFrame(null).setVisible(true);
            }
        });
    }
}

