/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.packager.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

public class PropertyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static List<String> COLUMN_NAMES = new ArrayList<String>(Arrays.asList("Property", "Value"));
    private Properties props = null;

    public PropertyTableModel(Properties props) {
        this.props = props;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.size();
    }

    @Override
    public int getRowCount() {
        return this.props.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (COLUMN_NAMES.get(col) == "Property") {
            return new ArrayList<Object>(this.props.keySet()).get(row);
        }
        if (COLUMN_NAMES.get(col) == "Value") {
            return new ArrayList<Object>(this.props.values()).get(row);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return COLUMN_NAMES.get(col) == "Value";
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        Object key = new ArrayList<Object>(this.props.keySet()).get(row);
        this.props.setProperty(key.toString(), val.toString());
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES.get(col);
    }
}

