/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.packager.swing;

import fr.emac.gind.packager.AbstractPackager;
import fr.emac.gind.packager.component.AbstractComponent;
import fr.emac.gind.packager.swing.PropertyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ShowConfigurationJFrame
extends JFrame {
    private AbstractPackager installer;
    private JButton jButtonCancel;
    private JButton jButtonSave;
    private JPanel jPanelConf;
    private JPanel jPanelMain;
    private JScrollPane jScrollPaneConf;
    private JScrollPane jScrollPaneMain;

    public ShowConfigurationJFrame(AbstractPackager installer) {
        this.initComponents();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getWidth()) / 2, (dim.height - this.getHeight()) / 2);
        this.installer = installer;
        this.jPanelConf.removeAll();
        this.jPanelConf.setLayout(new GridLayout(installer.getComponents().size(), 1));
        for (AbstractComponent comp : installer.getComponents()) {
            JPanel confComp = new JPanel();
            confComp.setLayout(new BorderLayout());
            confComp.add((Component)new JLabel("component: " + comp.getName()), "North");
            confComp.setSize(new Dimension(this.getWidth(), 150));
            confComp.setMaximumSize(new Dimension(this.getWidth(), 150));
            confComp.setPreferredSize(new Dimension(this.getWidth(), 150));
            JScrollPane jScrollPaneComp = new JScrollPane();
            JTable tableComp = new JTable();
            tableComp.setModel(new PropertyTableModel(this.installer.getConfigManager().getProperties(comp)));
            jScrollPaneComp.setViewportView(tableComp);
            confComp.add((Component)jScrollPaneComp, "Center");
            this.jPanelConf.add(confComp);
        }
    }

    private void initComponents() {
        this.jScrollPaneMain = new JScrollPane();
        this.jPanelMain = new JPanel();
        this.jScrollPaneConf = new JScrollPane();
        this.jPanelConf = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("Global configuration");
        GroupLayout jPanelConfLayout = new GroupLayout(this.jPanelConf);
        this.jPanelConf.setLayout(jPanelConfLayout);
        jPanelConfLayout.setHorizontalGroup(jPanelConfLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 777, Short.MAX_VALUE));
        jPanelConfLayout.setVerticalGroup(jPanelConfLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 597, Short.MAX_VALUE));
        this.jScrollPaneConf.setViewportView(this.jPanelConf);
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowConfigurationJFrame.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShowConfigurationJFrame.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneConf, -1, 779, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSave))).addContainerGap()));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneConf).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave).addComponent(this.jButtonCancel)).addGap(12, 12, 12)));
        this.jScrollPaneMain.setViewportView(this.jPanelMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneMain, -1, 801, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneMain));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        try {
            this.installer.getConfigManager().save();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error to save configuration", 0);
        }
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ShowConfigurationJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ShowConfigurationJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ShowConfigurationJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ShowConfigurationJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ShowConfigurationJFrame(null).setVisible(true);
            }
        });
    }
}

