package fr.emac.gind.workflow.generator;

/*
 * #%L
 * abstract-workflow-deduction
 * %%
 * Copyright (C) 2014 - 2015 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.models.client.ModelsGovClient;
import fr.emac.gind.gov.rules.client.RulesGovClient;
import fr.emac.gind.workflow.report.GJaxbData;
import fr.emac.gind.workflow.report.GJaxbReports;
import fr.gind.emac.gov.core_gov.CoreGov;

/**
 *
 *
 * @author: Nicolas Salatge (nicolas.salatge@mines-albi.fr)
 */
public abstract class AbstractProcessGenerator {


  private AbstractDeductionStrategy deductionStrategy = null;
  private AbstractWorkflowRunnerExtension workflowRunnerExtension = null;
  private AbstractCampaignAnalyzer campaignAnalyzer = null;


  public AbstractProcessGenerator() {

  }

  public AbstractProcessGenerator(AbstractDeductionStrategy deductionStrategy, AbstractWorkflowRunnerExtension workflowRunnerExtension, AbstractCampaignAnalyzer campaignAnalyzer) {
    this.deductionStrategy = deductionStrategy;
    this.workflowRunnerExtension = workflowRunnerExtension;
    this.campaignAnalyzer = campaignAnalyzer;
  }

  public AbstractDeductionStrategy getDeductionStrategy() {
    return deductionStrategy;
  }

  public void setDeductionStrategy(AbstractDeductionStrategy deductionStrategy) {
    this.deductionStrategy = deductionStrategy;
  }

  public AbstractWorkflowRunnerExtension getWorkflowRunnerExtension() {
    return workflowRunnerExtension;
  }

  public void setWorkflowRunnerExtension(
      AbstractWorkflowRunnerExtension workflowRunnerExtension) {
    this.workflowRunnerExtension = workflowRunnerExtension;
  }

  public AbstractCampaignAnalyzer getCampaignAnalyzer() {
    return campaignAnalyzer;
  }

  public void setCampaignAnalyzer(AbstractCampaignAnalyzer campaignAnalyzer) {
    this.campaignAnalyzer = campaignAnalyzer;
  }

  
  public String getJavascriptOrCssExtensions() {
    String res = "";
    
    if(this.deductionStrategy != null && this.deductionStrategy.getJavascriptOrCssExtensions() != null) {
      res = res + this.deductionStrategy.getJavascriptOrCssExtensions();
    }
    if(this.workflowRunnerExtension != null && this.workflowRunnerExtension.getJavascriptOrCssExtensions() != null) {
      res = res + this.workflowRunnerExtension.getJavascriptOrCssExtensions();
    }
    
    return res;
  }
  
  public String getDirectives() {
    String res = "";
    
    if(this.deductionStrategy != null && this.deductionStrategy.getDirectives() != null) {
      res = res + this.deductionStrategy.getDirectives();
    }
    if(this.workflowRunnerExtension != null && this.workflowRunnerExtension.getDirectives() != null) {
      res = res + this.workflowRunnerExtension.getDirectives();
    }
    
    return res;
  }
}
