/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.workflow.generator;

import fr.emac.gind.commons.utils.color.ColorHelper;
import fr.emac.gind.commons.utils.jaxb.JSONJAXBContext;
import fr.emac.gind.commons.utils.jaxb.SOAException;
import fr.emac.gind.commons.utils.list.ListUtil;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.gov.core_gov.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbNode;
import fr.emac.gind.models.core.service.ModelsGovImpl;
import fr.emac.gind.models.generic.modeler.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.GenericModelManager;
import fr.emac.gind.workflow.report.GJaxbReport;
import fr.emac.gind.workflow.report.GJaxbStatusType;
import fr.gind.emac.gov.core_gov.CoreGov;
import fr.gind.emac.gov.core_gov.QueryFault;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDeductionHelper {
    private static Logger LOG = LoggerFactory.getLogger((String)ProcessDeductionHelper.class.getName());
    private static Map<fr.emac.gind.modeler.genericmodel.GJaxbNode, String> organizationColors = new HashMap<fr.emac.gind.modeler.genericmodel.GJaxbNode, String>();

    public static TreeMap<Integer, Map<fr.emac.gind.modeler.genericmodel.GJaxbNode, List<fr.emac.gind.modeler.genericmodel.GJaxbNode>>> createMapObjectivesByEffectOrRiskByPriority(String currentCollaborationName, String currentKnowledgeSpaceName, GJaxbReport report, JSONArray ordering, CoreGovClient coreClient) throws SOAException, QueryFault {
        TreeMap<Integer, Map<fr.emac.gind.modeler.genericmodel.GJaxbNode, List<fr.emac.gind.modeler.genericmodel.GJaxbNode>>> objectivesByEffectOrRiskByPiority = new TreeMap<Integer, Map<fr.emac.gind.modeler.genericmodel.GJaxbNode, List<fr.emac.gind.modeler.genericmodel.GJaxbNode>>>();
        for (int i = 0; i < ordering.length(); ++i) {
            fr.emac.gind.modeler.genericmodel.GJaxbNode effectOrRisk = (fr.emac.gind.modeler.genericmodel.GJaxbNode)JSONJAXBContext.getInstance().unmarshall("{ \"node\" : " + ordering.getJSONObject(i).getJSONObject("object").toString() + " }", fr.emac.gind.modeler.genericmodel.GJaxbNode.class);
            HashMap<fr.emac.gind.modeler.genericmodel.GJaxbNode, List> objectivesByEffectOrRisk = new HashMap<fr.emac.gind.modeler.genericmodel.GJaxbNode, List>();
            GJaxbGenericModel assoObj = coreClient.singleQuery(new String("match (n1)-[:`{http://fr.emac.gind/core-model}Concerns`]->(n2 { modelNodeId: '" + effectOrRisk.getId() + "_c__${collaboration}_k__${knowledgeSpace}' }) return n1").replace("${collaboration}", currentCollaborationName).replace("${knowledgeSpace}", currentKnowledgeSpaceName), currentCollaborationName, currentKnowledgeSpaceName);
            if (assoObj == null || assoObj.getNode() == null || assoObj.getNode().size() == 0) {
                report.getResult().getAnalyticReport().setStatus(GJaxbStatusType.INCOMPLETE);
                report.getResult().getAnalyticReport().setReportMessage(report.getResult().getAnalyticReport().getReportMessage() + "Error: Impossible to find at least one objective corresponding to this effect or risk: " + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)effectOrRisk) + "\n");
            }
            if (assoObj != null && assoObj.getNode() != null) {
                assoObj.getNode().forEach(obj -> obj.setUserData("associatedEffectOrRisk", (Object)effectOrRisk));
                objectivesByEffectOrRisk.put(effectOrRisk, assoObj.getNode());
            }
            objectivesByEffectOrRiskByPiority.put(new Integer(i), objectivesByEffectOrRisk);
        }
        return objectivesByEffectOrRiskByPiority;
    }

    public static Map<fr.emac.gind.modeler.genericmodel.GJaxbNode, GJaxbGenericModel> createMapPathByObjective(String currentCollaborationName, String currentKnowledgeSpaceName, GJaxbReport report, TreeMap<Integer, Map<fr.emac.gind.modeler.genericmodel.GJaxbNode, List<fr.emac.gind.modeler.genericmodel.GJaxbNode>>> objectivesByEffectOrRiskByPiority, CoreGovClient coreClient) throws QueryFault {
        HashMap<fr.emac.gind.modeler.genericmodel.GJaxbNode, GJaxbGenericModel> pathByObj = new HashMap<fr.emac.gind.modeler.genericmodel.GJaxbNode, GJaxbGenericModel>();
        for (Map<fr.emac.gind.modeler.genericmodel.GJaxbNode, List<fr.emac.gind.modeler.genericmodel.GJaxbNode>> effectOrRiskByObjectives : objectivesByEffectOrRiskByPiority.values()) {
            for (List<fr.emac.gind.modeler.genericmodel.GJaxbNode> objectives : effectOrRiskByObjectives.values()) {
                for (fr.emac.gind.modeler.genericmodel.GJaxbNode obj : objectives) {
                    List pathsModel = coreClient.multipleQuery(new String("match p = allShortestPaths((a:organization)-[:`{http://fr.emac.gind/core-model}Provides`|:`{http://fr.emac.gind/core-model}Satisfies`|:`{http://fr.emac.gind/core-model}Concerns`|:near*]-(o:objective { modelNodeId : '" + obj.getId() + "_c__${collaboration}_k__${knowledgeSpace}'} ))  where filter(x in nodes(p) where x:`${collaboration}`:`${knowledgeSpace}`) and any(c in nodes(p) where c:function and c.node_status = 'ACTIF') and any(o in nodes(p) where o:objective and o.node_status = 'ACTIF' and o.modelNodeId = '" + obj.getId() + "_c__${collaboration}_k__${knowledgeSpace}') and a.node_status = 'ACTIF' and o.node_status = 'ACTIF' return p  ").replace("${collaboration}", currentCollaborationName).replace("${knowledgeSpace}", currentKnowledgeSpaceName), currentCollaborationName, currentKnowledgeSpaceName);
                    if (pathsModel != null && !pathsModel.isEmpty()) {
                        Map.Entry<Double, GJaxbGenericModel> bestPath = ProcessDeductionHelper.findBestPath(pathsModel);
                        pathByObj.put(obj, bestPath.getValue());
                        continue;
                    }
                    pathByObj.put(obj, null);
                }
            }
        }
        return pathByObj;
    }

    public static Map.Entry<Double, GJaxbGenericModel> findBestPath(List<GJaxbGenericModel> pathsModel) {
        TreeMap orderingPathsByPertinenceIndice = new TreeMap();
        double pertinenceIndiceMax = 0.0;
        GJaxbGenericModel bestPath = null;
        for (GJaxbGenericModel path : pathsModel) {
            double pertinenceIndice = ProcessDeductionHelper.calculatePertinenceIndice(path);
            if (orderingPathsByPertinenceIndice.get(pertinenceIndice) == null) {
                orderingPathsByPertinenceIndice.put(pertinenceIndice, new ArrayList());
            }
            ((List)orderingPathsByPertinenceIndice.get(pertinenceIndice)).add(path);
        }
        pertinenceIndiceMax = (Double)orderingPathsByPertinenceIndice.lastKey();
        List bestPaths = (List)orderingPathsByPertinenceIndice.get(pertinenceIndiceMax);
        int numberOfNodesMin = ((GJaxbGenericModel)bestPaths.get(0)).getNode().size();
        for (GJaxbGenericModel path : bestPaths) {
            if (path.getNode().size() > numberOfNodesMin) continue;
            numberOfNodesMin = path.getNode().size();
            bestPath = path;
        }
        AbstractMap.SimpleEntry<Double, Object> entry = new AbstractMap.SimpleEntry<Double, Object>(pertinenceIndiceMax, bestPath);
        return entry;
    }

    public static double calculatePertinenceIndice(GJaxbGenericModel path) {
        double res = 1.0;
        for (GJaxbEdge edge : path.getEdge()) {
            GJaxbProperty satisfiesProp = GenericModelHelper.findProperty((String)"coverage", (List)edge.getProperty());
            if (satisfiesProp != null && satisfiesProp.getValue() != null) {
                double coverage = Double.parseDouble(satisfiesProp.getValue()) / 100.0;
                res *= coverage;
                continue;
            }
            GJaxbProperty nearProp = GenericModelHelper.findProperty((String)"near at", (List)edge.getProperty());
            if (nearProp == null || nearProp.getValue() == null) continue;
            double near = Double.parseDouble(nearProp.getValue()) / 100.0;
            res *= near;
        }
        return res * 100.0;
    }

    public static String printPath(GJaxbGenericModel path) {
        Object pathS = "";
        List<fr.emac.gind.modeler.genericmodel.GJaxbNode> startingNodes = ProcessDeductionHelper.findStartingNodes(path);
        assert (startingNodes != null && !startingNodes.isEmpty());
        fr.emac.gind.modeler.genericmodel.GJaxbNode currentNode = startingNodes.get(0);
        boolean reverse = false;
        ArrayList<GJaxbEdge> edges = new ArrayList<GJaxbEdge>(path.getEdge());
        while (currentNode != null) {
            GJaxbEdge currentEdge = ProcessDeductionHelper.findEdgeWhereSourceIs(edges, currentNode);
            if (currentEdge != null && !reverse) {
                pathS = (String)pathS + "(" + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)currentNode) + ")->";
                currentNode = currentEdge.getTarget();
                edges.remove(currentEdge);
                continue;
            }
            currentEdge = ProcessDeductionHelper.findEdgeWhereTargetIs(edges, currentNode);
            if (currentEdge != null) {
                reverse = true;
                pathS = (String)pathS + "(" + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)currentNode) + ")<-";
                currentNode = currentEdge.getSource();
                edges.remove(currentEdge);
                continue;
            }
            pathS = (String)pathS + "(" + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)currentNode) + ")";
            currentNode = null;
        }
        return pathS;
    }

    private static List<fr.emac.gind.modeler.genericmodel.GJaxbNode> findStartingNodes(GJaxbGenericModel path) {
        List nonStartingNodes = path.getEdge().parallelStream().map(e -> e.getSource()).collect(Collectors.toList());
        nonStartingNodes = ListUtil.deleteDuplicate(nonStartingNodes);
        ArrayList<fr.emac.gind.modeler.genericmodel.GJaxbNode> res = new ArrayList<fr.emac.gind.modeler.genericmodel.GJaxbNode>();
        for (fr.emac.gind.modeler.genericmodel.GJaxbNode node : path.getNode()) {
            res.add(GenericModelHelper.cloneNode((fr.emac.gind.modeler.genericmodel.GJaxbNode)node));
        }
        res.removeAll(nonStartingNodes);
        return res;
    }

    private static GJaxbEdge findEdgeWhereSourceIs(List<GJaxbEdge> edges, fr.emac.gind.modeler.genericmodel.GJaxbNode currentNode) {
        for (GJaxbEdge edge : edges) {
            if (!edge.getSource().getId().equals(currentNode.getId())) continue;
            return edge;
        }
        return null;
    }

    private static GJaxbEdge findEdgeWhereTargetIs(List<GJaxbEdge> edges, fr.emac.gind.modeler.genericmodel.GJaxbNode currentNode) {
        for (GJaxbEdge edge : edges) {
            if (!edge.getTarget().getId().equals(currentNode.getId())) continue;
            return edge;
        }
        return null;
    }

    public static fr.emac.gind.modeler.genericmodel.GJaxbNode findFirstStartEvent(List<fr.emac.gind.modeler.genericmodel.GJaxbNode> nodes) {
        Optional<fr.emac.gind.modeler.genericmodel.GJaxbNode> optNode = nodes.parallelStream().filter(n -> n.getRole().contains("startEvent")).findAny();
        if (optNode.isPresent()) {
            return optNode.get();
        }
        throw new RuntimeException("no start event in process!");
    }

    public static fr.emac.gind.modeler.genericmodel.GJaxbNode findFirstInPath(List<fr.emac.gind.modeler.genericmodel.GJaxbNode> nodes) {
        for (fr.emac.gind.modeler.genericmodel.GJaxbNode node : nodes) {
            GJaxbProperty first = GenericModelHelper.findProperty((String)"firstInPath", (List)node.getProperty());
            if (first == null || first.getValue() == null || !Boolean.valueOf(first.getValue()).booleanValue()) continue;
            return node;
        }
        return null;
    }

    public static void showProcess(fr.emac.gind.modeler.genericmodel.GJaxbNode startEvent, TreeMap<Integer, Map.Entry<fr.emac.gind.modeler.genericmodel.GJaxbNode, List<fr.emac.gind.modeler.genericmodel.GJaxbNode>>> orderingGateways, fr.emac.gind.modeler.genericmodel.GJaxbNode endEvent) {
        ArrayList<Object> process = new ArrayList<Object>();
        process.add(startEvent);
        for (Map.Entry<fr.emac.gind.modeler.genericmodel.GJaxbNode, List<fr.emac.gind.modeler.genericmodel.GJaxbNode>> gateway : orderingGateways.values()) {
            if (gateway.getValue().size() > 1) {
                process.add(gateway.getValue());
                continue;
            }
            process.add(gateway.getValue().get(0));
        }
        process.add(endEvent);
        int i = 1;
        for (Object e : process) {
            if (!(e instanceof fr.emac.gind.modeler.genericmodel.GJaxbNode)) {
                System.out.print("step " + i + ": ");
                if (e != null) {
                    for (fr.emac.gind.modeler.genericmodel.GJaxbNode node : (List)e) {
                        System.out.print(GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)node) + ", ");
                    }
                }
            }
            ++i;
        }
    }

    public static fr.emac.gind.modeler.genericmodel.GJaxbNode findOrganization(GenericModelManager manager) {
        List organizations = manager.getNodesByType(new QName("http://fr.emac.gind/crisis_functions", "Actor"));
        for (fr.emac.gind.modeler.genericmodel.GJaxbNode organization : organizations) {
            if (!manager.findInputEdgesOfNode(organization).isEmpty()) continue;
            return organization;
        }
        return null;
    }

    public static fr.emac.gind.modeler.genericmodel.GJaxbNode findFirstService(GenericModelManager manager, fr.emac.gind.modeler.genericmodel.GJaxbNode organization) {
        List services = manager.getNodesByRoles(new String[]{"function"});
        for (fr.emac.gind.modeler.genericmodel.GJaxbNode service : services) {
            List edges = manager.findInputEdgesOfNode(service);
            for (GJaxbEdge edge : edges) {
                if (edge.getSource() != organization || !edge.getType().equals(new QName("http://fr.emac.gind/core-model", "Provides"))) continue;
                return service;
            }
        }
        return null;
    }

    public static fr.emac.gind.modeler.genericmodel.GJaxbNode createTask(fr.emac.gind.modeler.genericmodel.GJaxbNode function, fr.emac.gind.modeler.genericmodel.GJaxbNode objective, fr.emac.gind.modeler.genericmodel.GJaxbNode organization) throws SOAException {
        fr.emac.gind.modeler.genericmodel.GJaxbNode task = new fr.emac.gind.modeler.genericmodel.GJaxbNode();
        task.setId("task_" + UUID.randomUUID().toString());
        if (function.getRole().contains("human_function")) {
            task.setType(new QName("http://fr.emac.gind/core-model", "HumanTask"));
            if (GenericModelHelper.findProperty((String)"Attributed to", (List)function.getProperty()) != null) {
                task.getProperty().add(GenericModelHelper.findProperty((String)"Attributed to", (List)function.getProperty()));
            }
            if (GenericModelHelper.findProperty((String)"Priority", (List)function.getProperty()) != null) {
                task.getProperty().add(GenericModelHelper.findProperty((String)"Priority", (List)function.getProperty()));
            }
            task.getRole().add("human_task");
        } else if (function.getRole().contains("computer_function")) {
            task.setType(new QName("http://fr.emac.gind/core-model", "ComputerTask"));
            task.getRole().add("computer_task");
        } else if (function.getRole().contains("mediation_function")) {
            task.setType(new QName("http://fr.emac.gind/core-model", "MediationTask"));
            if (GenericModelHelper.findProperty((String)"type", (List)function.getProperty()) != null) {
                task.getProperty().add(GenericModelHelper.findProperty((String)"type", (List)function.getProperty()));
            }
            task.getRole().add("mediation_task");
        }
        if (organization != null) {
            String color = organizationColors.get(organization);
            if (color == null) {
                color = ColorHelper.randomHexaColor();
                organizationColors.put(organization, color);
            }
            task.setColor(color);
            GenericModelHelper.findProperty((String)"color", (List)task.getProperty(), (boolean)true).setValue(color);
        } else {
            String rcolor = ColorHelper.randomHexaColor();
            task.setColor(rcolor);
            GenericModelHelper.findProperty((String)"color", (List)task.getProperty(), (boolean)true).setValue(rcolor);
        }
        task.getRole().add("task");
        task.getRole().add("temp");
        task.getProperty().add(GenericModelHelper.createProperty((String)"monitorable", (String)"true"));
        task.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)function)));
        if (GenericModelHelper.findProperty((String)"Input Properties", (List)function.getProperty()) != null) {
            task.getProperty().add((GJaxbProperty)GenericModelHelper.findProperty((String)"Input Properties", (List)function.getProperty()).clone());
        }
        if (GenericModelHelper.findProperty((String)"Output Properties", (List)function.getProperty()) != null) {
            task.getProperty().add((GJaxbProperty)GenericModelHelper.findProperty((String)"Output Properties", (List)function.getProperty()).clone());
        }
        if (GenericModelHelper.findProperty((String)"produces", (List)function.getProperty()) != null) {
            task.getProperty().add((GJaxbProperty)GenericModelHelper.findProperty((String)"produces", (List)function.getProperty()).clone());
        }
        if (GenericModelHelper.findProperty((String)"consumes", (List)function.getProperty()) != null) {
            task.getProperty().add((GJaxbProperty)GenericModelHelper.findProperty((String)"consumes", (List)function.getProperty()).clone());
        }
        if (GenericModelHelper.findProperty((String)"requires", (List)function.getProperty()) != null) {
            task.getProperty().add((GJaxbProperty)GenericModelHelper.findProperty((String)"requires", (List)function.getProperty()).clone());
        }
        if (GenericModelHelper.findProperty((String)"duration", (List)function.getProperty()) != null) {
            task.getProperty().add((GJaxbProperty)GenericModelHelper.findProperty((String)"duration", (List)function.getProperty()).clone());
        }
        if (GenericModelHelper.findProperty((String)"cost", (List)function.getProperty()) != null) {
            task.getProperty().add((GJaxbProperty)GenericModelHelper.findProperty((String)"cost", (List)function.getProperty()).clone());
        }
        if (GenericModelHelper.findProperty((String)"fixed cost", (List)function.getProperty()) != null) {
            task.getProperty().add((GJaxbProperty)GenericModelHelper.findProperty((String)"fixed cost", (List)function.getProperty()).clone());
        }
        if (GenericModelHelper.findProperty((String)"production capacity", (List)function.getProperty()) != null) {
            task.getProperty().add((GJaxbProperty)GenericModelHelper.findProperty((String)"production capacity", (List)function.getProperty()).clone());
        }
        if (objective != null) {
            task.getProperty().add(GenericModelHelper.createProperty((String)"associatedObjectives", (String)("[{ 'name': '" + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)objective) + "', 'id': '" + objective.getId() + "' }]")));
        }
        if (function != null) {
            task.getProperty().add(GenericModelHelper.createProperty((String)"invokedFunction", (String)("[{ 'name': '" + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)function) + "', 'id': '" + function.getId() + "', 'type': '" + function.getType() + "' }]")));
        }
        if (organization != null) {
            task.getProperty().add(GenericModelHelper.createProperty((String)"belongToOrganization", (String)("[{ 'name': '" + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)organization) + "', 'id': '" + organization.getId() + "', 'type': '" + organization.getType() + "' }]")));
        }
        return task;
    }

    public static void insertNodeBefore(fr.emac.gind.modeler.genericmodel.GJaxbNode task, fr.emac.gind.modeler.genericmodel.GJaxbNode nodeAfter, GenericModelManager mm) {
        List edgesBeforeTask = mm.findInputEdgesOfNode(nodeAfter);
        GJaxbGenericModel process = (GJaxbGenericModel)mm.getModels().get(0);
        edgesBeforeTask.stream().forEach(e -> e.setTarget(task));
        GJaxbEdge edge2 = new GJaxbEdge();
        edge2.setId("sequence_" + UUID.randomUUID().toString());
        edge2.setType(new QName("http://fr.emac.gind/core-model", "SequenceFlow"));
        edge2.getRole().add("sequence_flow");
        edge2.getRole().add("temp");
        edge2.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)(GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)task) + " to " + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)nodeAfter))));
        edge2.setSource(task);
        edge2.setTarget(nodeAfter);
        process.getEdge().add(edge2);
        if (!ProcessDeductionHelper.containsNode(process, task)) {
            process.getNode().add(task);
        }
    }

    public static void insertNodeAfter(fr.emac.gind.modeler.genericmodel.GJaxbNode task, fr.emac.gind.modeler.genericmodel.GJaxbNode nodeBefore, GenericModelManager mm) {
        List edgesAfterTask = mm.findOutputEdgesOfNode(nodeBefore);
        GJaxbGenericModel process = (GJaxbGenericModel)mm.getModels().get(0);
        if (edgesAfterTask != null) {
            edgesAfterTask.stream().forEach(e -> e.setSource(task));
        }
        GJaxbEdge edge1 = new GJaxbEdge();
        edge1.setId("sequence_" + UUID.randomUUID().toString());
        edge1.setType(new QName("http://fr.emac.gind/core-model", "SequenceFlow"));
        edge1.getRole().add("sequence_flow");
        edge1.getRole().add("temp");
        edge1.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)(GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)nodeBefore) + " to " + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)task))));
        edge1.setSource(nodeBefore);
        edge1.setTarget(task);
        process.getEdge().add(edge1);
        if (!ProcessDeductionHelper.containsNode(process, task)) {
            process.getNode().add(task);
        }
    }

    public static boolean containsNode(GJaxbGenericModel process, fr.emac.gind.modeler.genericmodel.GJaxbNode node) {
        return process.getNode().stream().filter(n -> n.getId().equals(node.getId())).count() > 0L;
    }

    public static boolean containsEdge(GJaxbGenericModel process, GJaxbEdge edge) {
        for (GJaxbEdge e : process.getEdge()) {
            if (!(edge.getSource() != null && edge.getTarget() != null ? e.getSource() != null && e.getSource().getId().equals(edge.getSource().getId()) && e.getTarget() != null && e.getTarget().getId().equals(edge.getTarget().getId()) : (edge.getSource() == null && edge.getTarget() != null ? e.getSource() == null && e.getTarget() != null && e.getTarget().getId().equals(edge.getTarget().getId()) : (edge.getSource() != null && edge.getTarget() == null ? e.getSource() != null && e.getSource().getId().equals(edge.getSource().getId()) && e.getTarget() == null : edge.getSource() == null && edge.getTarget() == null && e.getSource() == null && e.getTarget() == null)))) continue;
            return true;
        }
        return false;
    }

    public static fr.emac.gind.modeler.genericmodel.GJaxbNode findProject(String collaborationName, String knowledgeSpaceName, CoreGovClient coreClient) throws QueryFault {
        GJaxbQuery request = new GJaxbQuery();
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
        String name = knowledgeSpaceName.replace(" KnowledgeSpace", "");
        request.setQuery("Match (n:project:`" + collaborationName + "`:`" + knowledgeSpaceName + "` { property_name : '" + name + "' }) return n;");
        GJaxbQueryResponse response = coreClient.query(request);
        if (response != null && response.getSingle() != null && response.getSingle().getGenericModel() != null && response.getSingle().getGenericModel().getNode().size() > 0) {
            return (fr.emac.gind.modeler.genericmodel.GJaxbNode)response.getSingle().getGenericModel().getNode().get(0);
        }
        return null;
    }

    public static void removeNodeFromProcess(fr.emac.gind.modeler.genericmodel.GJaxbNode startEvent, GenericModelManager mmp) {
        mmp.findOutputEdgesOfNode(startEvent).clear();
        mmp.getModels().forEach(m -> m.getNode().remove(startEvent));
    }

    public static void insertNodeInEdge(fr.emac.gind.modeler.genericmodel.GJaxbNode task, GJaxbEdge edge, GenericModelManager merged_mm) {
        fr.emac.gind.modeler.genericmodel.GJaxbNode target = edge.getTarget();
        GJaxbGenericModel process = (GJaxbGenericModel)merged_mm.getModels().get(0);
        edge.setTarget(task);
        edge.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)(GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)edge.getSource()) + " to " + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)task))));
        GJaxbEdge edge1 = new GJaxbEdge();
        edge1.setId("sequence_" + UUID.randomUUID().toString());
        edge1.setType(new QName("http://fr.emac.gind/core-model", "SequenceFlow"));
        edge1.getRole().add("sequence_flow");
        edge1.getRole().add("temp");
        edge1.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)(GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)task) + " to " + GenericModelHelper.getName((fr.emac.gind.modeler.genericmodel.GJaxbNode)target))));
        edge1.setSource(task);
        edge1.setTarget(target);
        process.getEdge().add(edge1);
        if (!ProcessDeductionHelper.containsNode(process, task)) {
            process.getNode().add(task);
        }
    }

    public static GJaxbGenericModel extractProcess(CoreGov coreClient, String processId, String startEventId, GJaxbEffectiveMetaModel metaModel, String collaborationName, String knowledgeSpaceName) throws Exception {
        GJaxbGenericModel extra_response;
        GJaxbQueryResponse res;
        GJaxbSelectedKnowledgeSpace ck;
        GJaxbQuery q;
        GJaxbGenericModel process = null;
        Object where = " where (";
        String or = "";
        for (GJaxbNode node : metaModel.getNode()) {
            where = (String)where + or + "n1.type = '" + node.getType().toString().trim() + "'";
            or = " OR ";
        }
        where = (String)where + ") AND (";
        or = "";
        for (GJaxbNode node : metaModel.getNode()) {
            where = (String)where + or + "n2.type = '" + node.getType().toString().trim() + "'";
            or = " OR ";
        }
        where = (String)where + " )";
        if (processId != null) {
            LOG.debug("processId = " + processId);
            q = new GJaxbQuery();
            q.setQuery("match (n1:startEvent { property_processId : '" + processId + "' }) OPTIONAL MATCH (n1 { node_status : 'ACTIF' })-[r1*]->(n2 { node_status : 'ACTIF' }) " + (String)where + " return distinct n1, r1, n2");
            ck = new GJaxbSelectedKnowledgeSpace();
            ck.setCollaborationName(collaborationName);
            ck.setKnowledgeName(knowledgeSpaceName);
            q.setSelectedKnowledgeSpace(ck);
            q.setViewName("process");
            res = coreClient.query(q);
            process = res.getSingle().getGenericModel();
        } else if (startEventId != null) {
            LOG.debug("startEventId = " + startEventId);
            q = new GJaxbQuery();
            q.setQuery("match (n1:startEvent { modelNodeId   : '" + startEventId + "_c__" + collaborationName + "_k__" + knowledgeSpaceName + "' }) OPTIONAL MATCH (n1 { node_status : 'ACTIF' })-[r1*]->(n2 { node_status : 'ACTIF' }) " + (String)where + " return distinct n1, r1, n2");
            ck = new GJaxbSelectedKnowledgeSpace();
            ck.setCollaborationName(collaborationName);
            ck.setKnowledgeName(knowledgeSpaceName);
            q.setSelectedKnowledgeSpace(ck);
            q.setViewName("process");
            res = coreClient.query(q);
            process = res.getSingle().getGenericModel();
        }
        GJaxbEffectiveMetaModel metaModelWithoutTasksAndEvents = (GJaxbEffectiveMetaModel)metaModel.clone();
        metaModelWithoutTasksAndEvents.getNode().removeIf(metaNode -> metaNode.getRole().contains("task") || metaNode.getRole().contains("event") || metaNode.getRole().contains("gateway"));
        GJaxbQuery q2 = new GJaxbQuery();
        q2.setQuery(ModelsGovImpl.createExtractionRuleFromMetaModelByType((GJaxbEffectiveMetaModel)metaModelWithoutTasksAndEvents, (String)collaborationName, (String)knowledgeSpaceName));
        GJaxbSelectedKnowledgeSpace ck2 = new GJaxbSelectedKnowledgeSpace();
        ck2.setCollaborationName(collaborationName);
        ck2.setKnowledgeName(knowledgeSpaceName);
        q2.setSelectedKnowledgeSpace(ck2);
        q2.setViewName("process");
        GJaxbQueryResponse queryResp = coreClient.query(q2);
        if (queryResp != null && queryResp.getSingle() != null && (extra_response = queryResp.getSingle().getGenericModel()) != null) {
            if (extra_response.getNode() != null) {
                for (fr.emac.gind.modeler.genericmodel.GJaxbNode n : extra_response.getNode()) {
                    if (ProcessDeductionHelper.containsNode(process, n)) continue;
                    process.getNode().add(n);
                }
            }
            if (extra_response.getEdge() != null) {
                for (GJaxbEdge e : extra_response.getEdge()) {
                    if (ProcessDeductionHelper.containsEdge(process, e)) continue;
                    process.getEdge().add(e);
                }
            }
        }
        process.getEdge().removeIf(edge -> {
            if (edge != null && edge.getType() != null) {
                return edge.getType().toString().equals("isParentOf");
            }
            return false;
        });
        return process;
    }

    public static Optional<String> findProcessName(GJaxbGenericModel process) throws Exception {
        GenericModelManager mm = new GenericModelManager(new GJaxbGenericModel[]{process});
        List startEvents = mm.getNodesByRoles(new String[]{"startEvent"});
        Optional<String> processName = startEvents.stream().map(startEvent -> {
            GJaxbProperty processNameInSE = GenericModelHelper.findProperty((String)"processName", (List)startEvent.getProperty(), (boolean)true);
            return processNameInSE.getValue();
        }).filter(processNameInStartEvent -> processNameInStartEvent != null && !processNameInStartEvent.trim().isEmpty()).findFirst();
        return processName;
    }

    public static Optional<String> findProcessId(GJaxbGenericModel process) throws Exception {
        GenericModelManager mm = new GenericModelManager(new GJaxbGenericModel[]{process});
        List startEvents = mm.getNodesByRoles(new String[]{"startEvent"});
        Optional<String> processId = startEvents.stream().map(startEvent -> {
            GJaxbProperty processIdInSE = GenericModelHelper.findProperty((String)"processId", (List)startEvent.getProperty(), (boolean)true);
            return processIdInSE.getValue();
        }).filter(processIdInStartEvent -> processIdInStartEvent != null && !processIdInStartEvent.trim().isEmpty()).findFirst();
        return processId;
    }
}

