package fr.emac.gind.workflow.util;

/*
 * #%L
 * abstract-workflow-deduction-strategy
 * %%
 * Copyright (C) 2014 - 2017 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.util.AbstractMap;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;

import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.GenericModelHelper;
import fr.emac.gind.workflow.engine.Execution;

public class ResourceUtil {

  
  public static Entry<Double, String> findQuantityToProduceIfExist(Execution execution, GJaxbNode model) {
    Entry<Double, String> quantity = null;
    GJaxbProperty produces = GenericModelHelper.findProperty("produces", model.getProperty());
    if(produces != null && produces.getValue() != null && !produces.getValue().trim().isEmpty()) {
      JSONArray arrayProduces = new JSONArray(produces.getValue());
      for(int i = 0; i < arrayProduces.length(); i++) {
        JSONObject produce = arrayProduces.getJSONObject(i);

        GJaxbProperty taskInputs = GenericModelHelper.findProperty("Input Properties", model.getProperty());
        if(taskInputs.getValue() != null && !taskInputs.getValue().trim().isEmpty()) {
          JSONArray arrayInputs = new JSONArray(taskInputs.getValue());
          for(int j = 0; j < arrayInputs.length(); j++) {
            JSONObject input = arrayInputs.getJSONObject(j);
            if(input.getString("name").replace(" ", "_").replace("-", "_").toLowerCase().contains(produce.getString("name").replace(" ", "_").replace("-", "_").toLowerCase())) {
              String inputVar = input.getString("name");

              Element quantityElmt = (Element) execution.getVariableValue(inputVar).getValue(execution);
              
              Double quantityValue = Double.parseDouble(quantityElmt.getTextContent());
              quantity = new AbstractMap.SimpleEntry<Double, String>(quantityValue, produce.toString());
            }
          }
        }
      }
    }
    return quantity;
  }
}
