package fr.emac.gind.workflow.generator;

import java.util.List;

import fr.emac.gind.campaignManager.data.GJaxbCampaign;
import fr.emac.gind.campaignManager.data.GJaxbScenario;
import fr.emac.gind.commons.utils.excel.ExcelProjectManager;
import fr.emac.gind.models.generic.modeler.GenericModelManager;

/*
 * #%L
 * abstract-workflow-deduction-strategy
 * %%
 * Copyright (C) 2014 - 2017 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


public abstract class AbstractCampaignAnalyzer {

  
  public abstract String getJavascriptOrCssExtensions();

  public abstract String getDirectives();
    
  
  public abstract void generateSpecificAnalysis(GenericModelManager mm, GJaxbScenario scenario) throws Exception;
  
  public abstract void createSpecificSheetScenarios(ExcelProjectManager excel,  GJaxbCampaign campaign, List<GJaxbScenario> scenario) throws Exception;
  
  
}
