package fr.emac.gind.workflow.generator;


/*
 * #%L
 * abstract-workflow-deduction-strategy
 * %%
 * Copyright (C) 2014 - 2017 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.emac.gind.workflow.engine.Execution;
import fr.emac.gind.workflow.engine.Node;

public abstract class AbstractWorkflowRunnerExtension {


  public AbstractWorkflowRunnerExtension() {

  }

  public abstract void onProcessStarted(Execution execution, fr.emac.gind.workflow.engine.Process process) throws Exception;

  public abstract void onProcessEnded(Execution execution, fr.emac.gind.workflow.engine.Process process) throws Exception;
  
  public abstract void onHumanTaskExecuteEnded(Execution execution, Node node) throws Exception;


  public abstract String getJavascriptOrCssExtensions();


  public abstract String getDirectives();

}
