package fr.emac.gind.workflow.generator;

import java.util.Map;

/*
 * #%L
 * abstract-workflow-deduction-strategy
 * %%
 * Copyright (C) 2014 - 2017 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.models.client.ModelsGovClient;
import fr.emac.gind.gov.rules.client.RulesGovClient;
import fr.emac.gind.workflow.report.GJaxbData;
import fr.emac.gind.workflow.report.GJaxbReports;
import fr.gind.emac.gov.core_gov.CoreGov;

public abstract class AbstractDeductionStrategy {

  private CoreGov core = null;
  private CoreGovClient coreClient = null;
  private ModelsGovClient modelClient = null;
  private RulesGovClient ruleClient = null;
  private Map<String, Object> context = null;
  
  public AbstractDeductionStrategy() {
    
  }
  
  
  public Map<String, Object> getContext() {
    return context;
  }


  public void setContext(Map<String, Object> context) {
    this.context = context;
  }


  public void setCore(CoreGov core) {
    this.core = core;
  }

  public CoreGovClient getCoreClient() {
    return coreClient;
  }

  public void setCoreClient(CoreGovClient coreClient) {
    this.coreClient = coreClient;
  }

  public ModelsGovClient getModelClient() {
    return modelClient;
  }

  public void setModelClient(ModelsGovClient modelClient) {
    this.modelClient = modelClient;
  }

  public RulesGovClient getRuleClient() {
    return ruleClient;
  }

  public void setRuleClient(RulesGovClient ruleClient) {
    this.ruleClient = ruleClient;
  }

  public abstract String getName();
  
  
  public abstract GJaxbReports deduceProcess(String currentCollaborationName, String currentKnowledgeSpaceName, GJaxbData data) throws Exception;
  
  public abstract String getJavascriptFunctionToCall();
  
  public abstract String getDescription();
  
  public abstract String getJavascriptOrCssExtensions();


  public abstract String getDirectives();
  
}
