/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.workflow.generator;

import fr.emac.gind.commons.utils.color.ColorHelper;
import fr.emac.gind.commons.utils.jaxb.JSONJAXBContext;
import fr.emac.gind.commons.utils.jaxb.SOAException;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.gov.core_gov.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.GenericModelManager;
import fr.emac.gind.workflow.report.GJaxbReport;
import fr.emac.gind.workflow.report.GJaxbStatusType;
import fr.gind.emac.gov.core_gov.QueryFault;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.json.JSONArray;

public class ProcessDeductionHelper {
    private static Map<GJaxbNode, String> organizationColors = new HashMap<GJaxbNode, String>();

    public static TreeMap<Integer, Map<GJaxbNode, List<GJaxbNode>>> createMapObjectivesByEffectOrRiskByPriority(String currentCollaborationName, String currentKnowledgeSpaceName, GJaxbReport report, JSONArray ordering, CoreGovClient coreClient) throws SOAException, QueryFault {
        TreeMap<Integer, Map<GJaxbNode, List<GJaxbNode>>> objectivesByEffectOrRiskByPiority = new TreeMap<Integer, Map<GJaxbNode, List<GJaxbNode>>>();
        for (int i = 0; i < ordering.length(); ++i) {
            GJaxbNode effectOrRisk = (GJaxbNode)JSONJAXBContext.getInstance().unmarshall("{ \"node\" : " + ordering.getJSONObject(i).getJSONObject("object").toString() + " }", GJaxbNode.class);
            HashMap<GJaxbNode, List> objectivesByEffectOrRisk = new HashMap<GJaxbNode, List>();
            GJaxbGenericModel assoObj = coreClient.singleQuery(new String("match (n1)-[:`{http://fr.emac.gind/core-model}Concerns`]->(n2 { modelNodeId: '" + effectOrRisk.getId() + "_c__${collaboration}_k__${knowledgeSpace}' }) return n1").replace("${collaboration}", currentCollaborationName).replace("${knowledgeSpace}", currentKnowledgeSpaceName), currentCollaborationName, currentKnowledgeSpaceName);
            if (assoObj == null || assoObj.getNode() == null || assoObj.getNode().size() == 0) {
                report.getResult().getAnalyticReport().setStatus(GJaxbStatusType.INCOMPLETE);
                report.getResult().getAnalyticReport().setReportMessage(report.getResult().getAnalyticReport().getReportMessage() + "Error: Impossible to find at least one objective corresponding to this effect or risk: " + GenericModelHelper.getName((GJaxbNode)effectOrRisk) + "\n");
            }
            if (assoObj != null && assoObj.getNode() != null) {
                assoObj.getNode().forEach(obj -> obj.setUserData("associatedEffectOrRisk", (Object)effectOrRisk));
                objectivesByEffectOrRisk.put(effectOrRisk, assoObj.getNode());
            }
            objectivesByEffectOrRiskByPiority.put(new Integer(i), objectivesByEffectOrRisk);
        }
        return objectivesByEffectOrRiskByPiority;
    }

    public static Map<GJaxbNode, GJaxbGenericModel> createMapPathByObjective(String currentCollaborationName, String currentKnowledgeSpaceName, GJaxbReport report, TreeMap<Integer, Map<GJaxbNode, List<GJaxbNode>>> objectivesByEffectOrRiskByPiority, CoreGovClient coreClient) throws QueryFault {
        HashMap<GJaxbNode, GJaxbGenericModel> pathByObj = new HashMap<GJaxbNode, GJaxbGenericModel>();
        for (Map<GJaxbNode, List<GJaxbNode>> effectOrRiskByObjectives : objectivesByEffectOrRiskByPiority.values()) {
            for (List<GJaxbNode> objectives : effectOrRiskByObjectives.values()) {
                for (GJaxbNode obj : objectives) {
                    List pathsModel = coreClient.multipleQuery(new String("match p = allShortestPaths((a:organization)-[:`{http://fr.emac.gind/core-model}Provides`|:`{http://fr.emac.gind/core-model}Satisfies`|:`{http://fr.emac.gind/core-model}Concerns`|:near*]-(o:objective { modelNodeId : '" + obj.getId() + "_c__${collaboration}_k__${knowledgeSpace}'} ))  where filter(x in nodes(p) where x:`${collaboration}`:`${knowledgeSpace}`) and any(c in nodes(p) where c:function and c.node_status = 'ACTIF') and any(o in nodes(p) where o:objective and o.node_status = 'ACTIF' and o.modelNodeId = '" + obj.getId() + "_c__${collaboration}_k__${knowledgeSpace}') and a.node_status = 'ACTIF' and o.node_status = 'ACTIF' return p  ").replace("${collaboration}", currentCollaborationName).replace("${knowledgeSpace}", currentKnowledgeSpaceName), currentCollaborationName, currentKnowledgeSpaceName);
                    if (pathsModel != null && !pathsModel.isEmpty()) {
                        Map.Entry<Double, GJaxbGenericModel> bestPath = ProcessDeductionHelper.findBestPath(pathsModel);
                        pathByObj.put(obj, bestPath.getValue());
                        continue;
                    }
                    pathByObj.put(obj, null);
                }
            }
        }
        return pathByObj;
    }

    public static Map.Entry<Double, GJaxbGenericModel> findBestPath(List<GJaxbGenericModel> pathsModel) {
        TreeMap orderingPathsByPertinenceIndice = new TreeMap();
        double pertinenceIndiceMax = 0.0;
        GJaxbGenericModel bestPath = null;
        for (GJaxbGenericModel path : pathsModel) {
            double pertinenceIndice = ProcessDeductionHelper.calculatePertinenceIndice(path);
            if (orderingPathsByPertinenceIndice.get(pertinenceIndice) == null) {
                orderingPathsByPertinenceIndice.put(pertinenceIndice, new ArrayList());
            }
            ((List)orderingPathsByPertinenceIndice.get(pertinenceIndice)).add(path);
        }
        pertinenceIndiceMax = (Double)orderingPathsByPertinenceIndice.lastKey();
        List bestPaths = (List)orderingPathsByPertinenceIndice.get(pertinenceIndiceMax);
        int numberOfNodesMin = ((GJaxbGenericModel)bestPaths.get(0)).getNode().size();
        for (GJaxbGenericModel path : bestPaths) {
            if (path.getNode().size() > numberOfNodesMin) continue;
            numberOfNodesMin = path.getNode().size();
            bestPath = path;
        }
        AbstractMap.SimpleEntry<Double, Object> entry = new AbstractMap.SimpleEntry<Double, Object>(pertinenceIndiceMax, bestPath);
        return entry;
    }

    public static double calculatePertinenceIndice(GJaxbGenericModel path) {
        double res = 1.0;
        for (GJaxbEdge edge : path.getEdge()) {
            GJaxbProperty satisfiesProp = GenericModelHelper.findProperty((String)"coverage", (List)edge.getProperty());
            if (satisfiesProp != null && satisfiesProp.getValue() != null) {
                double coverage = Double.parseDouble(satisfiesProp.getValue()) / 100.0;
                res *= coverage;
                continue;
            }
            GJaxbProperty nearProp = GenericModelHelper.findProperty((String)"near at", (List)edge.getProperty());
            if (nearProp == null || nearProp.getValue() == null) continue;
            double near = Double.parseDouble(nearProp.getValue()) / 100.0;
            res *= near;
        }
        return res * 100.0;
    }

    public static String printPath(GJaxbGenericModel path) {
        Object pathS = "";
        GJaxbNode currentNode = ProcessDeductionHelper.findStartNode(path.getNode());
        boolean reverse = false;
        ArrayList<GJaxbEdge> edges = new ArrayList<GJaxbEdge>(path.getEdge());
        while (currentNode != null) {
            GJaxbEdge currentEdge = ProcessDeductionHelper.findEdgeWhereSourceIs(edges, currentNode);
            if (currentEdge != null && !reverse) {
                pathS = (String)pathS + "(" + GenericModelHelper.getName((GJaxbNode)currentNode) + ")->";
                currentNode = currentEdge.getTarget();
                edges.remove(currentEdge);
                continue;
            }
            currentEdge = ProcessDeductionHelper.findEdgeWhereTargetIs(edges, currentNode);
            if (currentEdge != null) {
                reverse = true;
                pathS = (String)pathS + "(" + GenericModelHelper.getName((GJaxbNode)currentNode) + ")<-";
                currentNode = currentEdge.getSource();
                edges.remove(currentEdge);
                continue;
            }
            pathS = (String)pathS + "(" + GenericModelHelper.getName((GJaxbNode)currentNode) + ")";
            currentNode = null;
        }
        return pathS;
    }

    private static GJaxbEdge findEdgeWhereSourceIs(List<GJaxbEdge> edges, GJaxbNode currentNode) {
        for (GJaxbEdge edge : edges) {
            if (!edge.getSource().getId().equals(currentNode.getId())) continue;
            return edge;
        }
        return null;
    }

    private static GJaxbEdge findEdgeWhereTargetIs(List<GJaxbEdge> edges, GJaxbNode currentNode) {
        for (GJaxbEdge edge : edges) {
            if (!edge.getTarget().getId().equals(currentNode.getId())) continue;
            return edge;
        }
        return null;
    }

    private static GJaxbNode findStartNode(List<GJaxbNode> nodes) {
        for (GJaxbNode node : nodes) {
            GJaxbProperty first = GenericModelHelper.findProperty((String)"firstInPath", (List)node.getProperty());
            if (first == null || first.getValue() == null || !Boolean.valueOf(first.getValue()).booleanValue()) continue;
            return node;
        }
        return null;
    }

    public static void showProcess(GJaxbNode startEvent, TreeMap<Integer, Map.Entry<GJaxbNode, List<GJaxbNode>>> orderingGateways, GJaxbNode endEvent) {
        ArrayList<Object> process = new ArrayList<Object>();
        process.add(startEvent);
        for (Map.Entry<GJaxbNode, List<GJaxbNode>> gateway : orderingGateways.values()) {
            if (gateway.getValue().size() > 1) {
                process.add(gateway.getValue());
                continue;
            }
            process.add(gateway.getValue().get(0));
        }
        process.add(endEvent);
        int i = 1;
        for (Object e : process) {
            if (!(e instanceof GJaxbNode)) {
                System.out.print("step " + i + ": ");
                if (e != null) {
                    for (GJaxbNode node : (List)e) {
                        System.out.print(GenericModelHelper.getName((GJaxbNode)node) + ", ");
                    }
                }
            }
            ++i;
        }
    }

    public static GJaxbNode findOrganization(GenericModelManager manager) {
        List organizations = manager.getNodesByType(new QName("http://fr.emac.gind/crisis_functions", "Actor"));
        for (GJaxbNode organization : organizations) {
            if (!manager.findInputEdgesOfNode(organization).isEmpty()) continue;
            return organization;
        }
        return null;
    }

    public static GJaxbNode findFirstService(GenericModelManager manager, GJaxbNode organization) {
        List services = manager.getNodesByRoles(new String[]{"function"});
        for (GJaxbNode service : services) {
            List edges = manager.findInputEdgesOfNode(service);
            for (GJaxbEdge edge : edges) {
                if (edge.getSource() != organization || !edge.getType().equals(new QName("http://fr.emac.gind/core-model", "Provides"))) continue;
                return service;
            }
        }
        return null;
    }

    public static GJaxbNode createTask(GJaxbNode function, GJaxbNode objective, GJaxbNode organization) throws SOAException {
        GJaxbNode task = new GJaxbNode();
        task.setId("task_" + UUID.randomUUID().toString());
        if (function.getRole().contains("human_function")) {
            task.setType(new QName("http://fr.emac.gind/core-model", "HumanTask"));
            if (GenericModelHelper.findProperty((String)"Attributed to", (List)function.getProperty()) != null) {
                task.getProperty().add(GenericModelHelper.findProperty((String)"Attributed to", (List)function.getProperty()));
            }
            if (GenericModelHelper.findProperty((String)"Priority", (List)function.getProperty()) != null) {
                task.getProperty().add(GenericModelHelper.findProperty((String)"Priority", (List)function.getProperty()));
            }
            task.getRole().add("human_task");
        } else if (function.getRole().contains("computer_function")) {
            task.setType(new QName("http://fr.emac.gind/core-model", "ComputerTask"));
            task.getRole().add("computer_task");
        } else if (function.getRole().contains("mediation_function")) {
            task.setType(new QName("http://fr.emac.gind/core-model", "MediationTask"));
            if (GenericModelHelper.findProperty((String)"type", (List)function.getProperty()) != null) {
                task.getProperty().add(GenericModelHelper.findProperty((String)"type", (List)function.getProperty()));
            }
            task.getRole().add("mediation_task");
        }
        if (organization != null) {
            String color = organizationColors.get(organization);
            if (color == null) {
                color = ColorHelper.randomHexaColor();
                organizationColors.put(organization, color);
            }
            task.setColor(color);
            GenericModelHelper.findProperty((String)"color", (List)task.getProperty(), (boolean)true).setValue(color);
        }
        task.getRole().add("task");
        task.getRole().add("temp");
        task.getProperty().add(GenericModelHelper.createProperty((String)"monitorable", (String)"true"));
        task.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)GenericModelHelper.getName((GJaxbNode)function)));
        if (GenericModelHelper.findProperty((String)"Input Properties", (List)function.getProperty()) != null) {
            task.getProperty().add(GenericModelHelper.findProperty((String)"Input Properties", (List)function.getProperty()));
        }
        if (GenericModelHelper.findProperty((String)"Output Properties", (List)function.getProperty()) != null) {
            task.getProperty().add(GenericModelHelper.findProperty((String)"Output Properties", (List)function.getProperty()));
        }
        if (GenericModelHelper.findProperty((String)"produces", (List)function.getProperty()) != null) {
            task.getProperty().add(GenericModelHelper.findProperty((String)"produces", (List)function.getProperty()));
        }
        if (GenericModelHelper.findProperty((String)"consumes", (List)function.getProperty()) != null) {
            task.getProperty().add(GenericModelHelper.findProperty((String)"consumes", (List)function.getProperty()));
        }
        if (GenericModelHelper.findProperty((String)"requires", (List)function.getProperty()) != null) {
            task.getProperty().add(GenericModelHelper.findProperty((String)"requires", (List)function.getProperty()));
        }
        if (GenericModelHelper.findProperty((String)"duration", (List)function.getProperty()) != null) {
            task.getProperty().add(GenericModelHelper.findProperty((String)"duration", (List)function.getProperty()));
        }
        if (GenericModelHelper.findProperty((String)"cost", (List)function.getProperty()) != null) {
            task.getProperty().add(GenericModelHelper.findProperty((String)"cost", (List)function.getProperty()));
        }
        if (GenericModelHelper.findProperty((String)"fixed cost", (List)function.getProperty()) != null) {
            task.getProperty().add(GenericModelHelper.findProperty((String)"fixed cost", (List)function.getProperty()));
        }
        if (GenericModelHelper.findProperty((String)"production capacity", (List)function.getProperty()) != null) {
            task.getProperty().add(GenericModelHelper.findProperty((String)"production capacity", (List)function.getProperty()));
        }
        if (objective != null) {
            task.getProperty().add(GenericModelHelper.createProperty((String)"associatedObjectives", (String)("[{ 'name': '" + GenericModelHelper.getName((GJaxbNode)objective) + "', 'id': '" + objective.getId() + "' }]")));
        }
        if (function != null) {
            task.getProperty().add(GenericModelHelper.createProperty((String)"invokedFunction", (String)("[{ 'name': '" + GenericModelHelper.getName((GJaxbNode)function) + "', 'id': '" + function.getId() + "', 'type': '" + function.getType() + "' }]")));
        }
        if (organization != null) {
            task.getProperty().add(GenericModelHelper.createProperty((String)"belongToOrganization", (String)("[{ 'name': '" + GenericModelHelper.getName((GJaxbNode)organization) + "', 'id': '" + organization.getId() + "', 'type': '" + organization.getType() + "' }]")));
        }
        return task;
    }

    public static void insertNodeBefore(GJaxbNode task, GJaxbNode nodeAfter, GenericModelManager mm) {
        GJaxbEdge edgeToDelete = (GJaxbEdge)mm.findInputEdgesOfNode(nodeAfter).get(0);
        GJaxbNode nodeBefore = edgeToDelete.getSource();
        GJaxbGenericModel process = (GJaxbGenericModel)mm.getModels().get(0);
        process.getEdge().remove(edgeToDelete);
        GJaxbEdge edge1 = new GJaxbEdge();
        edge1.setId("sequence_" + UUID.randomUUID().toString());
        edge1.setType(new QName("http://fr.emac.gind/core-model", "SequenceFlow"));
        edge1.getRole().add("sequence_flow");
        edge1.getRole().add("temp");
        edge1.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)(GenericModelHelper.getName((GJaxbNode)nodeBefore) + " to " + GenericModelHelper.getName((GJaxbNode)task))));
        edge1.setSource(nodeBefore);
        edge1.setTarget(task);
        process.getEdge().add(edge1);
        GJaxbEdge edge2 = new GJaxbEdge();
        edge2.setId("sequence_" + UUID.randomUUID().toString());
        edge2.setType(new QName("http://fr.emac.gind/core-model", "SequenceFlow"));
        edge2.getRole().add("sequence_flow");
        edge2.getRole().add("temp");
        edge2.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)(GenericModelHelper.getName((GJaxbNode)task) + " to " + GenericModelHelper.getName((GJaxbNode)nodeAfter))));
        edge2.setSource(task);
        edge2.setTarget(nodeAfter);
        process.getEdge().add(edge2);
        if (!process.getNode().contains(task)) {
            process.getNode().add(task);
        }
    }

    public static void insertNodeAfter(GJaxbNode task, GJaxbNode nodeBefore, GenericModelManager mm) {
        GJaxbEdge edgeToDelete = mm.findOutputEdgesOfNode(nodeBefore).size() > 0 ? (GJaxbEdge)mm.findOutputEdgesOfNode(nodeBefore).get(0) : null;
        GJaxbNode nodeAfter = null;
        if (edgeToDelete != null) {
            nodeAfter = edgeToDelete.getTarget();
        }
        GJaxbGenericModel process = (GJaxbGenericModel)mm.getModels().get(0);
        if (edgeToDelete != null) {
            process.getEdge().remove(edgeToDelete);
        }
        GJaxbEdge edge1 = new GJaxbEdge();
        edge1.setId("sequence_" + UUID.randomUUID().toString());
        edge1.setType(new QName("http://fr.emac.gind/core-model", "SequenceFlow"));
        edge1.getRole().add("sequence_flow");
        edge1.getRole().add("temp");
        edge1.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)(GenericModelHelper.getName((GJaxbNode)nodeBefore) + " to " + GenericModelHelper.getName((GJaxbNode)task))));
        edge1.setSource(nodeBefore);
        edge1.setTarget(task);
        process.getEdge().add(edge1);
        if (nodeAfter != null) {
            GJaxbEdge edge2 = new GJaxbEdge();
            edge2.setId("sequence_" + UUID.randomUUID().toString());
            edge2.setType(new QName("http://fr.emac.gind/core-model", "SequenceFlow"));
            edge2.getRole().add("sequence_flow");
            edge2.getRole().add("temp");
            edge2.getProperty().add(GenericModelHelper.createProperty((String)"name", (String)(GenericModelHelper.getName((GJaxbNode)task) + " to " + GenericModelHelper.getName((GJaxbNode)nodeAfter))));
            edge2.setSource(task);
            edge2.setTarget(nodeAfter);
            process.getEdge().add(edge2);
        }
        if (!process.getNode().contains(task)) {
            process.getNode().add(task);
        }
    }

    public static GJaxbNode findProject(String collaborationName, String knowledgeSpaceName, CoreGovClient coreClient) throws QueryFault {
        GJaxbQuery request = new GJaxbQuery();
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
        String name = knowledgeSpaceName.replace(" KnowledgeSpace", "");
        request.setQuery("Match (n:project:`" + collaborationName + "`:`" + knowledgeSpaceName + "` { property_name : '" + name + "' }) return n;");
        GJaxbQueryResponse response = coreClient.query(request);
        if (response != null && response.getSingle() != null && response.getSingle().getGenericModel() != null && response.getSingle().getGenericModel().getNode().size() > 0) {
            return (GJaxbNode)response.getSingle().getGenericModel().getNode().get(0);
        }
        return null;
    }
}

