/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.logger;

/*
 * #%L
 * logger
 * %%
 * Copyright (C) 2014 - 2019 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.util.Map;

import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.event.Level;

/**
*
*
* @author Nicolas Salatge 
*/
public abstract class AbstractJSONLogger {
	
	protected static JSONObject format(String msg,  Map<String, String> othersInfo) {
		JSONObject logJson = new JSONObject();
		logJson.put("msg", msg);

		if(othersInfo != null) {
			othersInfo.forEach((k, v) -> {
				logJson.put(k, v);
			});
		}
		return logJson;
	}
	
	
	protected static void logJSON(Logger log, Level level, JSONObject obj) {
		switch(level) {
		case DEBUG:
			log.debug(obj.toString());
			break;
		case ERROR:
			log.error(obj.toString());
			break;
		case INFO:
			log.info(obj.toString());
			break;
		case TRACE:
			log.trace(obj.toString());
			break;
		case WARN:
			log.warn(obj.toString());
			break;
		default:
			log.warn("level unknown " + obj.toString());
			break;

		}
	}

}
