/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.bundle.config;

import java.util.ArrayList;
import java.util.List;

import fr.emac.gind.modeler.genericmodel.GJaxbProperty;

public class PropertiesGroup {
  
  private String groupName = null;
  private final List<GJaxbProperty> properties = new ArrayList<GJaxbProperty>();
  
  
  public PropertiesGroup() {
  }
  
  public PropertiesGroup(String groupName) {
    this.groupName = groupName;
  }
  
  
  public String getGroupName() {
    return groupName;
  }

  
  public void addPropertyIfExist(GJaxbProperty prop) {
    if(prop != null && prop.getValue() != null && !prop.getValue().isBlank()) {
      this.properties.add(prop);
    }
  }

  
  public List<GJaxbProperty> getProperties() {
    return properties;
  }
  
  
}
