/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.bundle.config;

import com.google.common.base.CaseFormat;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.rio.bundle.config.PropertiesGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUnifier {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConfigurationUnifier.class.getName());

    public static Configuration desunify(String componentName, RIOSuiteAbstractBundle bundle, File configFile) throws Exception {
        Configuration unifiedConf = bundle.getUnifiedConf();
        ArrayList<GJaxbProperty> componentProps = new ArrayList<GJaxbProperty>();
        for (Map.Entry entry : unifiedConf.getProperties().entrySet()) {
            if (((String)entry.getKey()).contains("...")) {
                if (componentName != null && ((String)entry.getKey()).contains(componentName + "...")) {
                    componentProps.add(GenericModelHelper.createProperty((String)((String)entry.getKey()), (String)((String)entry.getValue())));
                    continue;
                }
                if (componentName == null || !componentName.equalsIgnoreCase("all")) continue;
                componentProps.add(GenericModelHelper.createProperty((String)((String)entry.getKey()), (String)((String)entry.getValue())));
                continue;
            }
            componentProps.add(GenericModelHelper.createProperty((String)((String)entry.getKey()), (String)((String)entry.getValue())));
        }
        ConfigurationUnifier.replaceKeyByValue(componentProps, unifiedConf);
        HashMap<String, String> comPropsMap = new HashMap<String, String>();
        if (componentName == null || !componentName.equalsIgnoreCase("all")) {
            for (GJaxbProperty prop : componentProps) {
                if (prop.getName().contains("...")) {
                    prop.setName(prop.getName().substring(prop.getName().indexOf("...") + "...".length()));
                }
                if (comPropsMap.get(prop.getName()) == null) {
                    comPropsMap.put(prop.getName(), prop.getValue());
                    continue;
                }
                LOG.warn("conf prop already exist '" + prop.getName() + "' with value: " + (String)comPropsMap.get(prop.getName()));
            }
        } else if (componentName.equalsIgnoreCase("all")) {
            for (GJaxbProperty prop : componentProps) {
                comPropsMap.put(prop.getName(), prop.getValue());
            }
        }
        HashMap hashMap = new HashMap(comPropsMap);
        List<PropertiesGroup> groups = ConfigurationUnifier.sortPropertiesByGroup(comPropsMap);
        StringBuffer buffer = new StringBuffer();
        buffer.append(ConfigurationUnifier.addDiese(("# " + componentName + " properties #").length()));
        buffer.append("# " + componentName + " properties #\n");
        buffer.append(ConfigurationUnifier.addDiese(("# " + componentName + " properties #").length()));
        for (PropertiesGroup group : groups) {
            if (group.getGroupName() != null && !group.getGroupName().isBlank()) {
                buffer.append("\n# " + group.getGroupName() + "\n");
            }
            for (GJaxbProperty prop : group.getProperties()) {
                buffer.append(prop.getName() + " = " + prop.getValue() + "\n");
            }
            buffer.append("\n");
        }
        Configuration componentConf = null;
        if (configFile != null) {
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            FileUtil.setContents((File)configFile, (String)buffer.toString());
            componentConf = new Configuration(configFile.toURI().toURL());
        } else {
            componentConf = new Configuration(hashMap);
        }
        return componentConf;
    }

    private static void replaceKeyByValue(List<GJaxbProperty> componentProps, Configuration unifiedConf) {
        for (GJaxbProperty prop : componentProps) {
            Pattern pattern = Pattern.compile("(\\$\\{[^\\}]*\\})");
            Matcher matcher = pattern.matcher(prop.getValue());
            while (matcher.find()) {
                String key = matcher.group();
                String propName = key.replace("${", "").replace("}", "");
                String propValue = (String)unifiedConf.getProperties().get(propName);
                if (propValue == null) continue;
                prop.setValue(prop.getValue().replace(key, propValue));
            }
        }
    }

    public static Configuration unify(RIOSuiteAbstractBundle bundle) throws Exception {
        return ConfigurationUnifier.unify(bundle.getWebappServicesToActivate(), bundle.getSoapServicesToActivate());
    }

    public static Configuration unify(List<DWApplicationService> webappServices, List<Class<? extends SPIWebServicePrimitives>> wsServices) throws Exception {
        List<PropertiesGroup> groups;
        Map<Type, Map<String, Map<String, String>>> allConfMap = ConfigurationUnifier.unifyConf(webappServices, wsServices);
        Map<Type, SortedMap<Integer, Map<String, Map<String, String>>>> allSortedConfMap = ConfigurationUnifier.priorizeByPortProperty(allConfMap);
        ConfigurationUnifier.replaceValuesByPropertyKey(allSortedConfMap);
        StringBuffer buffer = new StringBuffer();
        buffer.append("###############################################\n");
        buffer.append("##                                           ##\n");
        buffer.append("##             Common Properties             ##\n");
        buffer.append("##                                           ##\n");
        buffer.append("###############################################\n");
        buffer.append("\n");
        for (Map.Entry<Integer, Map<String, Map<String, String>>> common_props_prio : allSortedConfMap.get((Object)Type.COMMON).entrySet()) {
            for (Map.Entry<String, Map<String, String>> common_props : common_props_prio.getValue().entrySet()) {
                groups = ConfigurationUnifier.sortPropertiesByGroup(common_props.getValue());
                for (PropertiesGroup group : groups) {
                    if (group.getGroupName() != null && !group.getGroupName().isBlank()) {
                        buffer.append("\n# " + group.getGroupName() + "\n");
                    }
                    for (GJaxbProperty prop : group.getProperties()) {
                        buffer.append(prop.getName() + " = " + prop.getValue() + "\n");
                    }
                    buffer.append("\n");
                }
            }
        }
        buffer.append("\n\n\n");
        buffer.append("###############################################\n");
        buffer.append("##                                           ##\n");
        buffer.append("##              Web Applications             ##\n");
        buffer.append("##                                           ##\n");
        buffer.append("###############################################\n");
        buffer.append("\n");
        for (Map.Entry<Integer, Map<String, Map<String, String>>> webapp_props_prio : allSortedConfMap.get((Object)Type.WEBAPP).entrySet()) {
            for (Map.Entry<String, Map<String, String>> webapp_props : webapp_props_prio.getValue().entrySet()) {
                buffer.append("# " + webapp_props.getKey() + " properties :\n");
                buffer.append(ConfigurationUnifier.addDiese(("# " + webapp_props.getKey() + " properties :").length()));
                groups = ConfigurationUnifier.sortPropertiesByGroup(webapp_props.getValue());
                for (PropertiesGroup group : groups) {
                    if (group.getGroupName() != null && !group.getGroupName().isBlank()) {
                        buffer.append("\n# " + group.getGroupName() + "\n");
                    }
                    for (GJaxbProperty prop : group.getProperties()) {
                        buffer.append(prop.getName() + " = " + prop.getValue() + "\n");
                    }
                    buffer.append("\n");
                }
            }
            buffer.append("\n\n");
        }
        buffer.append("\n\n\n");
        buffer.append("###############################################\n");
        buffer.append("##                                           ##\n");
        buffer.append("##                Web Services               ##\n");
        buffer.append("##                                           ##\n");
        buffer.append("###############################################\n");
        buffer.append("\n");
        for (Map.Entry<Integer, Map<String, Map<String, String>>> ws_props_prio : allSortedConfMap.get((Object)Type.WS).entrySet()) {
            for (Map.Entry<String, Map<String, String>> ws_props : ws_props_prio.getValue().entrySet()) {
                buffer.append("# " + ws_props.getKey() + " properties :\n");
                buffer.append(ConfigurationUnifier.addDiese(("# " + ws_props.getKey() + " properties :").length()));
                groups = ConfigurationUnifier.sortPropertiesByGroup(ws_props.getValue());
                for (PropertiesGroup group : groups) {
                    if (group.getGroupName() != null && !group.getGroupName().isBlank()) {
                        buffer.append("\n# " + group.getGroupName() + "\n");
                    }
                    for (GJaxbProperty prop : group.getProperties()) {
                        buffer.append(prop.getName() + " = " + prop.getValue() + "\n");
                    }
                    buffer.append("\n");
                }
            }
            buffer.append("\n\n");
        }
        buffer.append("\n\n\n");
        LOG.debug("conf buffer:\n" + String.valueOf(buffer));
        File unifiedConfFile = new File(Configuration.CONFIG_PATH, Configuration.CONFIG_NAME);
        unifiedConfFile.getParentFile().mkdirs();
        unifiedConfFile.createNewFile();
        FileUtil.setContents((File)unifiedConfFile, (String)buffer.toString());
        Configuration unifiedConf = new Configuration(unifiedConfFile.toURI().toURL());
        return unifiedConf;
    }

    private static Map<Type, SortedMap<Integer, Map<String, Map<String, String>>>> priorizeByPortProperty(Map<Type, Map<String, Map<String, String>>> allConfMap) {
        HashMap<Type, SortedMap<Integer, Map<String, Map<String, String>>>> priorityMap = new HashMap<Type, SortedMap<Integer, Map<String, Map<String, String>>>>();
        ArrayList<GJaxbProperty> appsByPort = new ArrayList<GJaxbProperty>();
        for (Map.Entry<Type, Map<String, Map<String, String>>> entry : allConfMap.entrySet()) {
            for (Map.Entry<String, Map<String, String>> propsByApp : entry.getValue().entrySet()) {
                String appName = propsByApp.getKey();
                Optional<Map.Entry> portEntry = propsByApp.getValue().entrySet().stream().filter(e -> ((String)e.getKey()).endsWith("...port")).findFirst();
                if (portEntry.isPresent()) {
                    String port = (String)portEntry.get().getValue();
                    appsByPort.add(GenericModelHelper.createProperty((String)appName, (String)port));
                    continue;
                }
                appsByPort.add(GenericModelHelper.createProperty((String)appName, (String)"0"));
            }
        }
        Collections.sort(appsByPort, new Comparator<GJaxbProperty>(){

            @Override
            public int compare(GJaxbProperty p1, GJaxbProperty p2) {
                Integer port1 = this.getInt(p1);
                Integer port2 = this.getInt(p2);
                return port1.compareTo(port2);
            }

            private int getInt(GJaxbProperty p) {
                try {
                    return Integer.parseInt(p.getValue());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        for (Map.Entry<Type, Map<String, Map<String, String>>> entry : allConfMap.entrySet()) {
            Type type = entry.getKey();
            priorityMap.put(type, new TreeMap());
            int priority = 0;
            for (GJaxbProperty appByPort : appsByPort) {
                Map<String, String> propsOfApp = entry.getValue().get(appByPort.getName());
                if (propsOfApp == null) continue;
                ((SortedMap)priorityMap.get((Object)type)).put(priority, new HashMap());
                ((Map)((SortedMap)priorityMap.get((Object)type)).get(priority)).put(appByPort.getName(), propsOfApp);
                ++priority;
            }
        }
        return priorityMap;
    }

    private static void replaceValuesByPropertyKey(Map<Type, SortedMap<Integer, Map<String, Map<String, String>>>> allSortedConfMap) {
        for (Map.Entry<Type, SortedMap<Integer, Map<String, Map<String, String>>>> entry1 : allSortedConfMap.entrySet()) {
            for (Map.Entry<Integer, Map<String, Map<String, String>>> entryPrio1 : entry1.getValue().entrySet()) {
                for (Map.Entry<String, Map<String, String>> propsByApp1 : entryPrio1.getValue().entrySet()) {
                    for (Map.Entry<String, String> prop1 : propsByApp1.getValue().entrySet()) {
                        String propKey1 = prop1.getKey();
                        String propValue1 = prop1.getValue();
                        for (Map.Entry<Type, SortedMap<Integer, Map<String, Map<String, String>>>> entry2 : allSortedConfMap.entrySet()) {
                            for (Map.Entry<Integer, Map<String, Map<String, String>>> entryPrio2 : entry2.getValue().entrySet()) {
                                for (Map.Entry<String, Map<String, String>> propsByApp2 : entryPrio2.getValue().entrySet()) {
                                    for (Map.Entry<String, String> prop2 : propsByApp2.getValue().entrySet()) {
                                        String propKey2 = prop2.getKey();
                                        String propValue2 = prop2.getValue();
                                        if (propKey1.equals(propKey2) || propValue1.contains("$") || !propValue2.contains(propValue1) || propValue2.equals("true") || propValue2.equals("false") || propKey2.contains("-login") || propKey2.contains("-pwd") || propKey2.contains("_login") || propKey2.contains("_password") || propKey1.equals("publish-lot-size") || propValue1.equals("gind")) continue;
                                        String newPropValue2 = propValue2.replace(propValue1, "${" + propKey1 + "}");
                                        propsByApp2.getValue().put(propKey2, newPropValue2);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static List<PropertiesGroup> sortPropertiesByGroup(Map<String, String> properties) {
        ArrayList<PropertiesGroup> groups = new ArrayList<PropertiesGroup>();
        PropertiesGroup defaultGroup = new PropertiesGroup();
        defaultGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("host", properties));
        defaultGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("protocol", properties));
        defaultGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("generation-date", properties));
        defaultGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("application", properties));
        defaultGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("proxy-port", properties));
        defaultGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("port", properties));
        defaultGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("version", properties));
        defaultGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("defaultAdmin", properties));
        if (defaultGroup.getProperties().size() > 0) {
            groups.add(defaultGroup);
        }
        PropertiesGroup neo4jGroup = new PropertiesGroup("Neo4j Database (see neo4j_clustering.conf or neo4j_embedded.conf for more informations)");
        neo4jGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("neo4j-database-embedded", properties));
        neo4jGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("neo4j-database-login", properties));
        neo4jGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("neo4j-database-pwd", properties));
        if (neo4jGroup.getProperties().size() > 0) {
            groups.add(neo4jGroup);
        }
        PropertiesGroup mongoGroup = new PropertiesGroup("Mongo Database");
        mongoGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("mongodb-database-embedded", properties));
        mongoGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("mongodb-database-name", properties));
        mongoGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("mongodb-database-host", properties));
        mongoGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("mongodb-database-port", properties));
        mongoGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("mongodb-database-auth_enabled", properties));
        mongoGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("mongodb-database-login", properties));
        mongoGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("mongodb-database-pwd", properties));
        if (mongoGroup.getProperties().size() > 0) {
            groups.add(mongoGroup);
        }
        PropertiesGroup h2GisGroup = new PropertiesGroup("H2Gis Database");
        h2GisGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("h2gis-database-url", properties));
        h2GisGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("h2gis-database-login", properties));
        h2GisGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("h2gis-database-pwd", properties));
        h2GisGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("h2gis-database-repository", properties));
        if (h2GisGroup.getProperties().size() > 0) {
            groups.add(h2GisGroup);
        }
        PropertiesGroup pythonGroup = new PropertiesGroup("Python");
        pythonGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("python-activated", properties));
        pythonGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains("python-ml-engine-port", properties));
        if (pythonGroup.getProperties().size() > 0) {
            groups.add(pythonGroup);
        }
        PropertiesGroup portGroup = new PropertiesGroup();
        List portProps = properties.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith("-port")).collect(Collectors.toList());
        Collections.sort(portProps, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> p1, Map.Entry<String, String> p2) {
                Integer port1 = this.getInt(p1);
                Integer port2 = this.getInt(p2);
                return port1.compareTo(port2);
            }

            private int getInt(Map.Entry<String, String> p1) {
                try {
                    return Integer.parseInt(p1.getValue());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        for (Map.Entry portP : portProps) {
            portGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains((String)portP.getKey(), properties));
        }
        if (portGroup.getProperties().size() > 0) {
            groups.add(portGroup);
        }
        PropertiesGroup publishGroup = new PropertiesGroup();
        List publishProps = properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("publish-")).collect(Collectors.toList());
        for (Map.Entry publishP : publishProps) {
            publishGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains((String)publishP.getKey(), properties));
        }
        if (publishGroup.getProperties().size() > 0) {
            groups.add(publishGroup);
        }
        PropertiesGroup httpGroup = new PropertiesGroup();
        List httpProps = properties.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("http://") || ((String)e.getValue()).startsWith("https://")).collect(Collectors.toList());
        for (Map.Entry httpP : httpProps) {
            httpGroup.addPropertyIfExist(ConfigurationUnifier.removeIfPropertiesContains((String)httpP.getKey(), properties));
        }
        if (httpGroup.getProperties().size() > 0) {
            groups.add(httpGroup);
        }
        PropertiesGroup othersGroup = new PropertiesGroup();
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            othersGroup.addPropertyIfExist(GenericModelHelper.createProperty((String)prop.getKey(), (String)prop.getValue()));
        }
        if (othersGroup.getProperties().size() > 0) {
            groups.add(othersGroup);
        }
        return groups;
    }

    private static GJaxbProperty removeIfPropertiesContains(String key, Map<String, String> properties) {
        GJaxbProperty prop = null;
        String value = properties.remove(key);
        if (value == null) {
            String complete_key = null;
            for (Map.Entry<String, String> p : properties.entrySet()) {
                if (!p.getKey().endsWith("..." + key)) continue;
                complete_key = p.getKey();
                break;
            }
            value = properties.remove(complete_key);
            prop = GenericModelHelper.createProperty(complete_key, (String)value);
        } else {
            prop = GenericModelHelper.createProperty((String)key, (String)value);
        }
        return prop;
    }

    private static String addDiese(int length) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buffer.append("#");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    private static Map<Type, Map<String, Map<String, String>>> unifyConf(List<DWApplicationService> webappServices, List<Class<? extends SPIWebServicePrimitives>> wsServices) throws Exception {
        HashMap allPropsMap = new HashMap();
        for (DWApplicationService dWApplicationService : webappServices) {
            Configuration default_serviceConf = ConfigurationUnifier.getConfigurationOfComponent(dWApplicationService.getName());
            for (Map.Entry entry : default_serviceConf.getProperties().entrySet()) {
                if (allPropsMap.get(entry.getKey()) == null) {
                    allPropsMap.put((String)entry.getKey(), new HashMap());
                }
                if (((Map)allPropsMap.get(entry.getKey())).get((Object)Type.WEBAPP) == null) {
                    ((Map)allPropsMap.get(entry.getKey())).put(Type.WEBAPP, new HashMap());
                }
                ((Map)((Map)allPropsMap.get(entry.getKey())).get((Object)Type.WEBAPP)).put(dWApplicationService.getName(), (String)entry.getValue());
            }
        }
        for (Class clazz : wsServices) {
            String confName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, clazz.getSimpleName());
            Configuration default_serviceConf = ConfigurationUnifier.getConfigurationOfComponent(confName);
            for (Map.Entry entry : default_serviceConf.getProperties().entrySet()) {
                if (allPropsMap.get(entry.getKey()) == null) {
                    allPropsMap.put((String)entry.getKey(), new HashMap());
                }
                if (((Map)allPropsMap.get(entry.getKey())).get((Object)Type.WS) == null) {
                    ((Map)allPropsMap.get(entry.getKey())).put(Type.WS, new HashMap());
                }
                ((Map)((Map)allPropsMap.get(entry.getKey())).get((Object)Type.WS)).put(confName, (String)entry.getValue());
            }
        }
        HashMap<Type, Map<String, Map<String, String>>> sortedPropsMap = new HashMap<Type, Map<String, Map<String, String>>>();
        sortedPropsMap.put(Type.COMMON, new HashMap());
        sortedPropsMap.put(Type.WEBAPP, new HashMap());
        sortedPropsMap.put(Type.WS, new HashMap());
        for (Map.Entry prop : allPropsMap.entrySet()) {
            if (ConfigurationUnifier.numberOfValues((Map)prop.getValue()) > 1) {
                List<String> values = ConfigurationUnifier.getDifferentValues((Map)prop.getValue());
                if (values.size() == 1) {
                    if (((Map)sortedPropsMap.get((Object)Type.COMMON)).get("common") == null) {
                        ((Map)sortedPropsMap.get((Object)Type.COMMON)).put("common", new HashMap());
                    }
                    ((Map)((Map)sortedPropsMap.get((Object)Type.COMMON)).get("common")).put((String)prop.getKey(), values.get(0));
                    continue;
                }
                LOG.warn("Several values for the same property '" + (String)prop.getKey() + "': " + String.valueOf(values));
                for (Map.Entry entry : ((Map)prop.getValue()).entrySet()) {
                    Type t = (Type)((Object)entry.getKey());
                    for (Map.Entry p : ((Map)entry.getValue()).entrySet()) {
                        String serviceName = (String)p.getKey();
                        String value = (String)p.getValue();
                        if (((Map)sortedPropsMap.get((Object)t)).get(serviceName) == null) {
                            ((Map)sortedPropsMap.get((Object)t)).put(serviceName, new HashMap());
                        }
                        ((Map)((Map)sortedPropsMap.get((Object)t)).get(serviceName)).put(serviceName + "..." + (String)prop.getKey(), value);
                    }
                }
                continue;
            }
            for (Map.Entry entry : ((Map)prop.getValue()).entrySet()) {
                Type type = (Type)((Object)entry.getKey());
                for (Map.Entry p : ((Map)entry.getValue()).entrySet()) {
                    String serviceName = (String)p.getKey();
                    String value = (String)p.getValue();
                    if (((Map)sortedPropsMap.get((Object)type)).get(serviceName) == null) {
                        ((Map)sortedPropsMap.get((Object)type)).put(serviceName, new HashMap());
                    }
                    ((Map)((Map)sortedPropsMap.get((Object)type)).get(serviceName)).put(serviceName + "..." + (String)prop.getKey(), value);
                }
            }
        }
        return sortedPropsMap;
    }

    private static int numberOfValues(Map<Type, Map<String, String>> valuesByApps) {
        int cpt = 0;
        for (Map.Entry<Type, Map<String, String>> valuesByApp : valuesByApps.entrySet()) {
            cpt += valuesByApp.getValue().size();
        }
        return cpt;
    }

    private static List<String> getDifferentValues(Map<Type, Map<String, String>> map) {
        ArrayList<String> differentValues = new ArrayList<String>();
        for (Map.Entry<Type, Map<String, String>> entry1 : map.entrySet()) {
            for (Map.Entry<String, String> entry2 : entry1.getValue().entrySet()) {
                if (differentValues.contains(entry2.getValue())) continue;
                differentValues.add(entry2.getValue());
            }
        }
        return differentValues;
    }

    public static Configuration getConfigurationOfComponent(String componentName) throws Exception {
        Configuration serviceConf = null;
        File confFile = new File("../conf/generated/" + componentName + "/conf/config.properties");
        if (confFile.exists()) {
            serviceConf = new Configuration(confFile.toURI().toURL());
            LOG.debug(componentName + ": Configuration file exist");
        } else if (Thread.currentThread().getContextClassLoader().getResource("test/conf/generated/" + componentName + "/conf/config.properties") != null) {
            serviceConf = new Configuration(Thread.currentThread().getContextClassLoader().getResource("test/conf/generated/" + componentName + "/conf/config.properties"));
            LOG.debug(componentName + ": Configuration found in class loader");
        } else if (Thread.currentThread().getContextClassLoader().getResource("conf/generated/" + componentName + "/conf/config.properties") != null) {
            serviceConf = new Configuration(Thread.currentThread().getContextClassLoader().getResource("conf/generated/" + componentName + "/conf/config.properties"));
            LOG.debug(componentName + ": Configuration found in class loader");
        }
        if (serviceConf == null) {
            throw new Exception("Impossible to find configuration file for: " + componentName);
        }
        return serviceConf;
    }

    public static enum Type {
        WEBAPP,
        WS,
        COMMON;

    }
}

