/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.suite;

import java.awt.Desktop;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOSuiteBundle extends RIOSuiteAbstractBundle {

	private static final Logger LOG = LoggerFactory.getLogger(RIOSuiteBundle.class.getName());

	public RIOSuiteBundle() throws Exception {
		super(List.of(), List.of());
	}

	public String banner() {
		return "\r\n" + 
				"  _____      _____ ____     _____       _ _       \r\n" + 
				" |  __ \\    |_   _/ __ \\   / ____|     (_) |      \r\n" + 
				" | |__) |_____| || |  | | | (___  _   _ _| |_ ___ \r\n" + 
				" |  _  /______| || |  | |  \\___ \\| | | | | __/ _ \\\r\n" + 
				" | | \\ \\     _| || |__| |  ____) | |_| | | ||  __/\r\n" + 
				" |_|  \\_\\   |_____\\____/  |_____/ \\__,_|_|\\__\\___|\r\n" + 
				"                                                  \r\n" + 
				" " ;
	}

	@Override
	public void run() throws Exception {
		run(true);

	}
	
	public void run(boolean openBrowser) throws Exception {
		super.run();
		if(Desktop.isDesktopSupported() && openBrowser) {
			if(Desktop.getDesktop().isSupported(java.awt.Desktop.Action.BROWSE)) {
				java.awt.Desktop.getDesktop().browse(new URI(rioga.getApplicationUrl()));
			}
		}
		LOG.info(
				banner() 
				+ this.getRioga().getApplicationUrl());

	}

}
