/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.suite.test;


import java.util.Arrays;

import fr.emac.gind.campaign.manager.server.CampaignManagerWebService;
import fr.emac.gind.event.broker.EventBrokerWebService;
import fr.emac.gind.game_master.GameMasterWebService;
import fr.emac.gind.governance.GovernanceWebService;
import fr.emac.gind.io.interpretation.engine.InterpretationEngineContainer;
import fr.emac.gind.monitoring.detection.DetectionWebService;
import fr.emac.gind.monitoring.server.MonitoringWebService;
import fr.emac.gind.r.ioda.RIODAService;
import fr.emac.gind.r.ioga.RIOGAService;
import fr.emac.gind.r.iose.RIOSEService;
import fr.emac.gind.r.iosemit.RIOSEMITService;
import fr.emac.gind.r.iowa.RIOWAService;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.sensors.controler.SensorControlerWebService;
import fr.emac.gind.sensors.manager.SensorManagerWebService;
import fr.emac.gind.storage.mongodb.EventStorageWebService;
import fr.emac.gind.workflow.engine.WorkflowContainer;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOSuiteInterpretationBundle extends RIOSuiteAbstractBundle {
  public RIOSuiteInterpretationBundle() throws Exception {
    super(Arrays.asList(new RIOGAService(), new RIODAService(), new RIOWAService(), new RIOSEService(), new RIOSEMITService()),
        Arrays.asList(
            EventStorageWebService.class,                            
            WorkflowContainer.class,                    
            GovernanceWebService.class,  
            GameMasterWebService.class,
            SensorManagerWebService.class, 
            SensorControlerWebService.class, 
            EventBrokerWebService.class,                           
            InterpretationEngineContainer.class,         
            DetectionWebService.class,                       
            CampaignManagerWebService.class,                
            MonitoringWebService.class)
        );
  }
}
