/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: josepe
 */
package fr.emac.gind.rio.suite.launcher;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.campaign.manager.launcher.CampaignManagerServerLauncher;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.database.launcher.MongoDBEmddedLauncher;
import fr.emac.gind.event.broker.launcher.EventBrokerLauncher;
import fr.emac.gind.generic.application.launcher.GenericApplicationLauncher;
import fr.emac.gind.governance.launcher.GovernanceLauncher;
import fr.emac.gind.h2gis.gis.launcher.H2GISGisLauncher;
import fr.emac.gind.io.interpretation.launcher.InterpretationEngineLauncher;
import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.launcher.Main;
import fr.emac.gind.mock.endpoints.manager.launcher.MockEndpointsManagerLauncher;
import fr.emac.gind.monitoring.detection.launcher.DetectionLauncher;
import fr.emac.gind.monitoring.launcher.MonitoringLauncher;
import fr.emac.gind.osm.gis.launcher.OSMGisLauncher;
import fr.emac.gind.rio.suite.RIOSuiteBundle;
import fr.emac.gind.sensors.controler.launcher.SensorControlerLauncher;
import fr.emac.gind.sensors.manager.launcher.SensorManagerLauncher;
import fr.emac.gind.storage.launcher.EventStorageLauncher;
import fr.emac.gind.storage.mongodb.launcher.StorageLauncher;
import fr.emac.gind.timeseries.mongodb.launcher.TimeSeriesLauncher;
import fr.emac.gind.workflow.engine.launcher.WFEngineLauncher;




/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOSuiteLauncher extends AbstractLauncher {

  private static final Logger LOG = LoggerFactory.getLogger(RIOSuiteLauncher.class.getName());
  
  static {
    Main.addLauncherToIgnore(GovernanceLauncher.class);
    Main.addLauncherToIgnore(InterpretationEngineLauncher.class);
    Main.addLauncherToIgnore(SensorManagerLauncher.class);
    Main.addLauncherToIgnore(SensorControlerLauncher.class);
    Main.addLauncherToIgnore(EventBrokerLauncher.class);
    Main.addLauncherToIgnore(H2GISGisLauncher.class);
    Main.addLauncherToIgnore(DetectionLauncher.class);
    Main.addLauncherToIgnore(CampaignManagerServerLauncher.class);
    Main.addLauncherToIgnore(OSMGisLauncher.class);
    Main.addLauncherToIgnore(MongoDBEmddedLauncher.class);
    Main.addLauncherToIgnore(MonitoringLauncher.class);
    Main.addLauncherToIgnore(GenericApplicationLauncher.class);
    Main.addLauncherToIgnore(MockEndpointsManagerLauncher.class);
    Main.addLauncherToIgnore(StorageLauncher.class);
    Main.addLauncherToIgnore(EventStorageLauncher.class);
    Main.addLauncherToIgnore(TimeSeriesLauncher.class);
    Main.addLauncherToIgnore(WFEngineLauncher.class);
    
  }
  
  
  RIOSuiteBundle runner = new RIOSuiteBundle();


 
  public RIOSuiteLauncher() throws Exception {
    super();
  }


  @Override
  public String getPromptName() {
    return "r-iosuite";
  }


  @Override
  public void startRunner(Configuration conf) throws Exception {
    runner.boot(conf);
    runner.run();
  }


  @Override
  public void stopRunner() throws Exception {
    runner.stop();
  }


  @Override
  public String getName() {
    return "R-IO Suite";
  }


  @Override
  public String getInfo() {
    StringBuffer res = new StringBuffer();
    res.append("R-IO Suite informations:\n");


    res.append("Number of Web Services exposed: " + runner.getWebservices().size() + "\n"); 
    res.append("\nList of Web Services:\n");
    for(SPIWebServicePrimitives ws: runner.getWebservices()) {
      res.append("\t- " + ws.getHost() + ":" + ws.getPort() + " started = " + ws.isStarted() + "\n");
    }



    return res.toString();
  }



}
