/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.suite;

import java.io.File;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.rio.bundle.config.ConfigurationUnifier;

public class ConfigurationUnifierTest {


  @Test
  public void unify() throws Exception {
    try {
      Configuration.CONFIG_PATH = "./target/";
      Configuration.CONFIG_NAME = "unified_config.properties";
      RIOSuiteBundle bundle =  new RIOSuiteBundle();
      Configuration unified_conf = ConfigurationUnifier.unify(bundle);
      Assertions.assertNotNull(unified_conf);
      bundle.setUnifiedConf(unified_conf);
      
      Configuration component_conf = ConfigurationUnifier.desunify("r-ioga", bundle, new File(Configuration.CONFIG_PATH, "/test-rioga-config.properties"));
      Assertions.assertNotNull(component_conf);
    } catch(Exception e) {
      e.printStackTrace();
      throw e;
    }
  }


}
