/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: josepe
 */
package fr.emac.gind.rio.suite;

import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.ws.StaticJettyServer;
import fr.emac.gind.launcher.AbstractLauncher;

/*
 * #%L
 * iosuite-standalone
 * %%
 * Copyright (C) 2014 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.launcher.Main;

/**
 *
 *
 * @author Nicolas Salatge
 */
@Disabled
public class LauncherTest {

	private static final Logger LOG = LoggerFactory.getLogger(LauncherTest.class.getName());


	@AfterEach
	public void teardown() throws Exception {
		StaticJettyServer.getInstance().stop(true);
		LocalRegistry.getInstance().clear();
	}

	@Test
	public void testMainTwice() throws Exception {
		testMain();
		Thread.sleep(1000);
		testMain();
	}

	@Test
	public void testMain() throws Exception {

	    FileUtil.deleteDirectory(new File(RIOConstant.RESOURCES_FOLDER));
	    FileUtil.deleteDirectory(new File("./target/usecases"));    
	    FileUtil.deleteDirectory(new File("./target/mongo-db"));    
	    FileUtil.deleteDirectory(new File("./target/neo4j-db"));  
	    FileUtil.deleteDirectory(new File("./target/listener"));


		Configuration.CONFIG_PATH = "./src/main/resources/conf/";


		ExecutorService service = Executors.newSingleThreadExecutor();
		service.execute(new Runnable() {

			@Override
			public void run() {
				try {
					AbstractLauncher.setUseHook(false);
					Main.main(Arrays.asList("start", "noconsole").toArray(new String[2]));

				} catch (Exception e) {
					// do nothing
					e.printStackTrace();
				}    
			}
		});

		while(!Main.isStarted()) {
			Thread.sleep(300);
			LOG.debug("Wait RIO Start");
		}


		Main.stop();
		
		StaticJettyServer.getInstance().stop(true);
		LocalRegistry.getInstance().clear();
		
		while(Main.isStarted()) {
			Thread.sleep(300);
			LOG.debug("Wait RIO Stop");
		}

	    FileUtil.deleteDirectory(new File(RIOConstant.RESOURCES_FOLDER));
	    FileUtil.deleteDirectory(new File("./target/usecases"));    
	    FileUtil.deleteDirectory(new File("./target/mongo-db"));    
	    FileUtil.deleteDirectory(new File("./target/neo4j-db"));  
	    FileUtil.deleteDirectory(new File("./target/listener"));

	}

}
