/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Sebastien REBIERE
 */
package fr.emac.gind.rio.suite.others.cathedral_crisis;

/*
 * #%L
 * iosuite-standalone
 * %%
 * Copyright (C) 2014 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import javax.xml.namespace.QName;

import fr.emac.gind.database.mongodb.embedded.EmbeddedMongoDb;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;

import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.crypt.MD5;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.io.JavaKillerProcess;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.bundle.config.ConfigurationUnifier;
import fr.emac.gind.rio.suite.RIOSuiteBundle;
import fr.emac.gind.workflow.engine.WorkflowContainer;

/**
 * Unit test for simple App.
 */
/**
 *
 *
 * @author Nicolas Salatge
 */
public class RioSuiteAppFullWithSpecificUsersAndUcCathedralCrisisTest {

	private static final Logger LOG = LoggerFactory
			.getLogger(RioSuiteAppFullWithSpecificUsersAndUcCathedralCrisisTest.class.getName());

	public static void main(String[] args) throws Exception {

		JavaKillerProcess.deleteOldJavaIfExist();
		EmbeddedMongoDb.deleteOldMongoIfExist();
		RIOConstant.RESOURCES_FOLDER = "./target/resourcesFolder";

		FileUtil.deleteDirectory(new File(RIOConstant.RESOURCES_FOLDER));
		FileUtil.deleteDirectory(new File("./target/usecases"));
		FileUtil.deleteDirectory(new File("./target/mongo-db"));
		FileUtil.deleteDirectory(new File("./target/questdb_data"));
		FileUtil.deleteDirectory(new File("./target/neo4j-db"));
		FileUtil.deleteDirectory(new File("./target/listener"));

		// For debug: add directly the authentication to context
		Map<String, Object> context = new HashMap<String, Object>();
		// context.put("currentToken", new AES().encrypt("admin@mines-albi.fr" + ":" +
		// MD5.cryptWithMD5("pwd")));
		// context.put("currentUser", user);

		long start = System.currentTimeMillis();
		RIOSuiteBundle suiteService = new RIOSuiteBundle();

		Configuration.CONFIG_PATH = "./src/main/resources/conf/";
		Configuration.CONFIG_NAME = "unified_config.properties";
		File unifiedConfFile = new File(Configuration.CONFIG_PATH, Configuration.CONFIG_NAME);
		unifiedConfFile.delete();
		Configuration suiteConfig = ConfigurationUnifier.unify(suiteService);
		File newUnifiedConfFile = new File(Configuration.CONFIG_PATH, Configuration.CONFIG_NAME);
		Assertions.assertTrue(newUnifiedConfFile.exists());

		// DESACTIVATE PYHON
		// suiteConfig.getProperties().put("host", "riosuite.org");
		// suiteConfig.getProperties().put("proxy-port", "443");
		// suiteConfig.getProperties().put("protocol", "https");
		suiteConfig.getProperties().put("python-activated", "false");
		//suiteConfig.getProperties().put("load-predefined-usecases",
		//		"[ { \"knowledgeSpaceName\" : \"Toulouse PrisonBreak\", \"collaborationName\" : \"R-IO Suite\" } ]");

		// suiteConfig.getProperties().put("load-predefined-usecases", "[ {
		// \"knowledgeSpaceName\" : \"RealWorld\", \"collaborationName\" : \"World\",
		// \"activateTweetsListener\" : false } ]");
		 suiteConfig.getProperties().put("load-predefined-usecases", "["
		 		+ "{ \"knowledgeSpaceName\" : \"Cathedral Albi Crisis\", \"collaborationName\" : \"R-IO Suite\" } "
		 		+ "]");
		// suiteConfig.getProperties().put("load-predefined-usecases", "[ {
		// \"knowledgeSpaceName\" : \"RealWorld\", \"collaborationName\" : \"World\",
		// \"activateTweetsListener\" : false }, "
		// + "{ \"knowledgeSpaceName\" : \"Synchronized terrorist attack Albi\",
		// \"collaborationName\" : \"Egcersis3\" } ]");

		fr.emac.gind.launcher.Configuration workflowconf = new Configuration(
				Thread.currentThread().getContextClassLoader()
						.getResource("conf/generated/workflow-container/conf/config.properties").toURI().toURL());
		workflowconf.getProperties().replace("repository", "./target/repository");
		suiteService.setSpecificConfigurationOfSubComponents(WorkflowContainer.class, workflowconf);

		suiteService.boot(suiteConfig);

		suiteService.run();
		long end = System.currentTimeMillis();
		long time = end - start;
		LOG.debug("\n\nTime to start (s): " + time / 1000);

		// fr.emac.gind.modeler.genericmodel.GJaxbNode firstUser =
		// createFirstUser(suiteService);
        suiteService.getRioga().getUserResource();
        suiteService.getRioga().getApplicationContext()
				.setCurrentUser(SystemResource.getDEFAULT_ADMIN());

		// add specific user
		addSpecificsUsers();
	}

	private static void addSpecificsUsers() throws Exception {
		// Thread.sleep(1000);
		if (new File("../../../../gind-prototype-riosuite-users/Audrey_FERTIER").exists()) {
			FileUtils.copyDirectory(new File("../../../../gind-prototype-riosuite-users/Audrey_FERTIER"),
					new File("./target/listener"));
		}
		// Thread.sleep(1000);
		if (new File("../../../../gind-prototype-riosuite-users/Frederick_BENABEN").exists()) {
			FileUtils.copyDirectory(new File("../../../../gind-prototype-riosuite-users/Frederick_BENABEN"),
					new File("./target/listener"));
		}
		// Thread.sleep(1000);
		if (new File("../../../../gind-prototype-riosuite-users/Nicolas_SALATGE").exists()) {
			FileUtils.copyDirectory(new File("../../../../gind-prototype-riosuite-users/Nicolas_SALATGE"),
					new File("./target/listener"));
		}
		// Thread.sleep(1000);
		if (new File("../../../../gind-prototype-riosuite-users/Sebastien_REBIERE").exists()) {
			FileUtils.copyDirectory(new File("../../../../gind-prototype-riosuite-users/Sebastien_REBIERE"),
					new File("./target/listener"));
		}
	}

	private static fr.emac.gind.modeler.genericmodel.GJaxbNode createFirstUser(RIOSuiteBundle suiteService)
			throws Exception {
		EffectiveMetaModelManager sysMan = new EffectiveMetaModelManager(
				suiteService.getRioga().getContextResource().getSystem());
		GJaxbEffectiveConceptType userMetaModel = sysMan
				.getConceptByType(new QName("http://fr.emac.gind/system", "User"));

		fr.emac.gind.modeler.genericmodel.GJaxbNode firstUser = GenericModelHelper
				.createNodeFromMetaModel(userMetaModel, true);

		firstUser.setId("node_" + UUID.randomUUID());
		GenericModelHelper.findProperty("firstName", firstUser.getProperty()).setValue("Ken");
		GenericModelHelper.findProperty("lastName", firstUser.getProperty()).setValue("Addams");
		GenericModelHelper.findProperty("name", firstUser.getProperty(), true).setValue("Ken Addams");
		GenericModelHelper.findProperty("login", firstUser.getProperty()).setValue("ka");
		GenericModelHelper.findProperty("email", firstUser.getProperty()).setValue("ka@mines-albi.fr");
		GenericModelHelper.findProperty("theme", firstUser.getProperty()).setValue("dark-theme");
		GenericModelHelper.findProperty("password", firstUser.getProperty())
				.setValue("crypto_" + MD5.cryptWithMD5("ka"));
		GenericModelHelper.findProperty("re-password", firstUser.getProperty())
				.setValue("crypto_" + MD5.cryptWithMD5("ka"));
		JSONObject roles = new JSONObject(GenericModelHelper.findProperty("roles", firstUser.getProperty()).getValue());
		roles.getJSONObject("admin").put("checked", false);
		roles.getJSONObject("user").put("checked", true);
		GenericModelHelper.findProperty("roles", firstUser.getProperty()).setValue(roles.toString());
		GenericModelHelper.findProperty("activate sounds", firstUser.getProperty()).setValue("no");
		suiteService.getRioga().getUserResource().register(null, firstUser);
		LOG.debug("First User Created!!!");

		return firstUser;
	}

}
