/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.rio.suite.utils;

import java.net.URL;
import java.util.Enumeration;

import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class WhereIsThisComingFrom
{
    public static void main(String[] args)
    {
        locate(ManagedSelector.class);
        locate(QueuedThreadPool.class);
    }

    public static void locate(Class<?> clazz)
    {
        try
        {
            ClassLoader cl = clazz.getClassLoader();
            String classAsResource = clazz.getName().replace('.', '/') + ".class";
            Enumeration<URL> urls = cl.getResources(classAsResource);
            System.out.printf("Looking for: %s%n", classAsResource);
            while (urls.hasMoreElements())
            {
                URL url = urls.nextElement();
                System.out.printf("Found: %s%n", url.toExternalForm());
            }
        }
        catch (Throwable t)
        {
            System.out.printf("Whoops: cannot locate: %s%n", clazz);
            t.printStackTrace();
        }
    }
}