/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Sebastien REBIERE
 */
package fr.emac.gind.usecases.iosuite.cambrai.concert;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

import fr.emac.gind.eventcommonsdata.GJaxbProcessStatusType;
import fr.emac.gind.usecases.riosuite.test.RIOSuiteOrchestrationTest;
import fr.emac.gind.workflow.deduction.SimpleSatisfactionStrategyDeductionCampaign;

/**
 * Unit test for simple App.
 */
/**
 *
 *
 * @author Nicolas Salatge
 */
@Disabled
public class UCCambraiConcertDOrchestrationTest extends RIOSuiteOrchestrationTest {

  private static final List<String> UC_HUMAN_TASKS = Arrays.asList(
      "Restore drinking water, electricity, etc.",
      "Prepare materials, set up deviation routes and accommodate  accommodations",
      "Make an assessment",
      "Prepare teams for the evacuation of Orleans",
      "Activate Crisis cell for the county 45",
      "Alert Prefecture",
      "Prepare evacuation, inform families and launch evacuation of hospitals and retirement homes threatened by floods",
      "Send press release",
      "Decide for Orleans evacuation",
      "Order evacuation",
      "Compel for evacuation",
      "Ask for military support",
      "Manage traffic",
      "Ensure logistic at the COD, set up an information cell and make a request for reinforcements to the COZ",
      "Reception and assistance to the persons accommodated"
      ); 
  
  public UCCambraiConcertDOrchestrationTest() throws Exception {
    super(new RIOUCCambraiConcert());
  }

  @Test
  public void doTestOrchestrateWithSatisfactionStrategyOK() throws Exception {
    Map<String, Entry<String, String>> humanAnswers = new HashMap<String, Map.Entry<String,String>>();
    UC_HUMAN_TASKS.forEach(key -> {
      Entry<String, String> value = new AbstractMap.SimpleEntry<String, String>("ACCEPT", "DONE");
      humanAnswers.put(key, value);
    });
    GJaxbProcessStatusType status = doTestOrchestrate(new UCCambraiConcertDeductionTest(), new SimpleSatisfactionStrategyDeductionCampaign(), humanAnswers, GJaxbProcessStatusType.ENDED);
      Assertions.assertEquals(status, GJaxbProcessStatusType.ENDED);
  }
  
  @Test
  public void doTestOrchestrateERRORALL() throws Exception {
    Map<String, Entry<String, String>> humanAnswers = new HashMap<String, Map.Entry<String,String>>();
    UC_HUMAN_TASKS.forEach(key -> {
      Entry<String, String> value = new AbstractMap.SimpleEntry<String, String>("ACCEPT", "ERROR");
      humanAnswers.put(key, value);
    });
    GJaxbProcessStatusType status = doTestOrchestrate(new UCCambraiConcertDeductionTest(), new SimpleSatisfactionStrategyDeductionCampaign(), humanAnswers, GJaxbProcessStatusType.CRASHED);
      Assertions.assertEquals(status, GJaxbProcessStatusType.CRASHED);
  }
  

  
  
 
}
