/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Sebastien REBIERE
 */
package fr.emac.gind.usecases.iosuite.cambrai.concert;

import org.junit.jupiter.api.Test;

import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.rio.dw.resources.gov.bo.DeduceInput;
import fr.emac.gind.usecases.riosuite.test.RIOSuiteDeductionTest;

/**
 * Unit test for simple App.
 */
/**
 *
 *
 * @author Nicolas Salatge
 */

public class UCCambraiConcertDeductionTest extends RIOSuiteDeductionTest {

	public UCCambraiConcertDeductionTest() throws Exception {
		super(new RIOUCCambraiConcert());
	}

	public static void main(String[] args) throws Exception {
		UCCambraiConcertDeductionTest test = new UCCambraiConcertDeductionTest();
		bundle = test.initBundle(); 
		test.runBundleAndLoadUsecases();
        bundle.getRioga().getUserResource();
        DWUser user = new DWUser(SystemResource.getDEFAULT_ADMIN(),
				bundle.getRioga().getUserResource().getSystemClient());
//	    JSONArray valueArray = retrieveNodesFromKnowledgeAsJSONArray("match (n:ACTIVE&" + Neo4JReqConstant.collab("Objective") + ") return n", "Objectives", user);
//	    GJaxbProperty  specificInputEntry = new GJaxbProperty();
//	    specificInputEntry.setName("satisfactionProperties");
//	    JSONArray finalArray = new JSONArray();
//	    JSONObject finalObject = new JSONObject();
//	    finalArray.put(finalObject);
//	    finalObject.put("name", "objectivesOrder");
//	    finalObject.put("value", valueArray);
//	    specificInputEntry.setValue(finalArray.toString());
//	    JSONObject specificInputObject = new JSONObject();
//	    specificInputObject.put("satisfactionProperties", finalArray.toString());

		DeduceInput request = new DeduceInput();
		request.setProcessGeneratorInstance(
				"{\"name\":\"Simple Satisfaction Strategy Process Deduction\",\"class\":\"fr.emac.gind.workflow.deduction.SimpleSatisfactionStrategyDeduction\",\"ng_function_params\":\"{\\\"showInputs\\\":true,\\\"showReport\\\":true,\\\"deploy\\\":false}\",\"favorite_domains\":\"collaborative\"}");
		request.setSpecificInputData(
				"{\"satisfactionProperties\":[{\"name\":\"objectivesOrderMap\",\"value\":\"{\\\"0\\\":[{\\\"brokenEdges\\\":{\\\"brokenEdge\\\":[{\\\"sourceId\\\":\\\"node_873c4aa8-501f-da20-1252-1e5c7b26d089\\\",\\\"edge\\\":{\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"targetPosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"sourcePosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"pathType\\\":\\\"LINE\\\"},{}]}]},\\\"property\\\":[{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"treat\\\"}],\\\"id\\\":\\\"edge_0dd2eba1-f49a-9fbc-af9f-052ffb40ef25\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Treats\\\"},\\\"targetId\\\":\\\"node_7c7b28ce-f64a-4b9d-8f9b-e42c66da4b3f\\\"},{\\\"sourceId\\\":\\\"node_873c4aa8-501f-da20-1252-1e5c7b26d089\\\",\\\"edge\\\":{\\\"property\\\":[{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"near\\\"},{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"}],\\\"id\\\":\\\"edge_8d3215cd-bef1-81ce-ba13-4fa76ec74b87\\\",\\\"type\\\":\\\"{http://fr.emac.gind/core-model}Near\\\"},\\\"targetId\\\":\\\"node_25558168-8bba-76ae-71ae-89a2bcfdddb9\\\"}]},\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"viewId\\\":\\\"view_2a439fdf-2c3e-7484-776e-970b1b827626\\\",\\\"position\\\":{\\\"x\\\":728,\\\"y\\\":965},\\\"dimension\\\":{\\\"width\\\":48,\\\"height\\\":48}}]}]},\\\"extends\\\":[\\\"{http://fr.emac.gind/core-model}Semantic_Concept\\\"],\\\"property\\\":[{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"},{\\\"name\\\":\\\"labels\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"infer by\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"priority\\\",\\\"value\\\":\\\"0\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"Establish security perimeter\\\"},{\\\"name\\\":\\\"use volunteers\\\",\\\"value\\\":\\\"no\\\"}],\\\"id\\\":\\\"node_873c4aa8-501f-da20-1252-1e5c7b26d089\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Objective\\\",\\\"status\\\":[\\\"ACTIVE\\\"],\\\"geolocation\\\":{\\\"itemView\\\":[{\\\"redesign\\\":null,\\\"point\\\":{\\\"image\\\":\\\"/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/objective.svg\\\"}}]}}],\\\"1\\\":[{\\\"brokenEdges\\\":{\\\"brokenEdge\\\":[{\\\"sourceId\\\":\\\"node_6be79fe8-ea75-636d-5214-bdb116d6b16b\\\",\\\"edge\\\":{\\\"property\\\":[{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"near\\\"},{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"}],\\\"id\\\":\\\"edge_7a9fc906-f237-c3d5-d90a-718e6fd3c1d5\\\",\\\"type\\\":\\\"{http://fr.emac.gind/core-model}Near\\\"},\\\"targetId\\\":\\\"node_86d38065-a3f3-392d-4ba6-000abac7c6af\\\"},{\\\"sourceId\\\":\\\"node_6be79fe8-ea75-636d-5214-bdb116d6b16b\\\",\\\"edge\\\":{\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"targetPosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"sourcePosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"pathType\\\":\\\"LINE\\\"},{}]}]},\\\"property\\\":[{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"treat\\\"}],\\\"id\\\":\\\"edge_97615512-5f1f-1cf5-4443-2c662e171b88\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Treats\\\"},\\\"targetId\\\":\\\"node_7c7b28ce-f64a-4b9d-8f9b-e42c66da4b3f\\\"}]},\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"viewId\\\":\\\"view_f33cf037-a9fe-b071-85d8-89e1a351893a\\\",\\\"position\\\":{\\\"x\\\":961,\\\"y\\\":297},\\\"dimension\\\":{\\\"width\\\":48,\\\"height\\\":48}}]}]},\\\"extends\\\":[\\\"{http://fr.emac.gind/core-model}Semantic_Concept\\\"],\\\"property\\\":[{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"},{\\\"name\\\":\\\"labels\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"infer by\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"priority\\\",\\\"value\\\":\\\"0\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"Evacuate the injured\\\"},{\\\"name\\\":\\\"use volunteers\\\",\\\"value\\\":\\\"no\\\"}],\\\"id\\\":\\\"node_6be79fe8-ea75-636d-5214-bdb116d6b16b\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Objective\\\",\\\"status\\\":[\\\"ACTIVE\\\"],\\\"geolocation\\\":{\\\"itemView\\\":[{\\\"redesign\\\":null,\\\"point\\\":{\\\"image\\\":\\\"/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/objective.svg\\\"}}]}}],\\\"2\\\":[{\\\"brokenEdges\\\":{\\\"brokenEdge\\\":[{\\\"sourceId\\\":\\\"node_359dd3aa-f9df-f1d2-950a-2f100b8f7235\\\",\\\"edge\\\":{\\\"property\\\":[{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"near\\\"},{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"}],\\\"id\\\":\\\"edge_29547043-90fb-51c5-b10a-751966e09f49\\\",\\\"type\\\":\\\"{http://fr.emac.gind/core-model}Near\\\"},\\\"targetId\\\":\\\"node_f9ab2411-0632-2b41-d880-dbb45b0a5dc7\\\"},{\\\"sourceId\\\":\\\"node_359dd3aa-f9df-f1d2-950a-2f100b8f7235\\\",\\\"edge\\\":{\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"targetPosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"sourcePosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"pathType\\\":\\\"LINE\\\"},{}]}]},\\\"property\\\":[{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"treat\\\"}],\\\"id\\\":\\\"edge_07cc4fc1-75fd-e845-d620-c8f5f11390ba\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Treats\\\"},\\\"targetId\\\":\\\"node_7c7b28ce-f64a-4b9d-8f9b-e42c66da4b3f\\\"}]},\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"viewId\\\":\\\"view_1179cf8a-ca8d-7044-833a-4703c7855951\\\",\\\"position\\\":{\\\"x\\\":681,\\\"y\\\":11},\\\"dimension\\\":{\\\"width\\\":48,\\\"height\\\":48}}]}]},\\\"extends\\\":[\\\"{http://fr.emac.gind/core-model}Semantic_Concept\\\"],\\\"property\\\":[{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"},{\\\"name\\\":\\\"labels\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"infer by\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"priority\\\",\\\"value\\\":\\\"0\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"Evacuate the people\\\"},{\\\"name\\\":\\\"use volunteers\\\",\\\"value\\\":\\\"no\\\"}],\\\"id\\\":\\\"node_359dd3aa-f9df-f1d2-950a-2f100b8f7235\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Objective\\\",\\\"status\\\":[\\\"ACTIVE\\\"],\\\"geolocation\\\":{\\\"itemView\\\":[{\\\"redesign\\\":null,\\\"point\\\":{\\\"image\\\":\\\"/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/objective.svg\\\"}}]}}],\\\"3\\\":[{\\\"brokenEdges\\\":{\\\"brokenEdge\\\":[{\\\"sourceId\\\":\\\"node_0338668c-95c6-b1af-69cb-7192f383a913\\\",\\\"edge\\\":{\\\"property\\\":[{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"near\\\"},{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"}],\\\"id\\\":\\\"edge_b7f16cde-71b6-aefc-ca64-f152277a08c6\\\",\\\"type\\\":\\\"{http://fr.emac.gind/core-model}Near\\\"},\\\"targetId\\\":\\\"node_1f3d2f7b-f766-25ad-5248-df73e75ec005\\\"},{\\\"sourceId\\\":\\\"node_0338668c-95c6-b1af-69cb-7192f383a913\\\",\\\"edge\\\":{\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"targetPosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"sourcePosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"pathType\\\":\\\"LINE\\\"},{}]}]},\\\"property\\\":[{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"treat\\\"}],\\\"id\\\":\\\"edge_643bf219-1540-8de0-6753-d1ec1497a485\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Treats\\\"},\\\"targetId\\\":\\\"node_7c7b28ce-f64a-4b9d-8f9b-e42c66da4b3f\\\"}]},\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"viewId\\\":\\\"view_9e506221-0b31-60e0-23ac-372982757562\\\",\\\"position\\\":{\\\"x\\\":954,\\\"y\\\":143},\\\"dimension\\\":{\\\"width\\\":48,\\\"height\\\":48}}]}]},\\\"extends\\\":[\\\"{http://fr.emac.gind/core-model}Semantic_Concept\\\"],\\\"property\\\":[{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"},{\\\"name\\\":\\\"labels\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"infer by\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"priority\\\",\\\"value\\\":\\\"0\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"Treat the wounded\\\"},{\\\"name\\\":\\\"use volunteers\\\",\\\"value\\\":\\\"no\\\"}],\\\"id\\\":\\\"node_0338668c-95c6-b1af-69cb-7192f383a913\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Objective\\\",\\\"status\\\":[\\\"ACTIVE\\\"],\\\"geolocation\\\":{\\\"itemView\\\":[{\\\"redesign\\\":null,\\\"point\\\":{\\\"image\\\":\\\"/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/objective.svg\\\"}}]}}]}\"},{\"name\":\"selectedPlanningSolver\",\"value\":\"Default\"},{\"name\":\"activeMoveImprover\",\"value\":\"true\"}]}");

		// Deduce process

//		GJaxbDeductionReports res = JSONJAXBContext.getInstance().unmarshall(bundle.getRioga().getResourcesManager()
//				.findResource(ProcessResource.class).deduceProcess(user, request), GJaxbDeductionReports.class);

	}

	@Override
	public GJaxbGenericModel doGenerateProcess_usingSatisfactionStrategy(DeduceInput request) throws Exception {
        this.bundle.getRioga().getUserResource();
        DWUser user = new DWUser(SystemResource.getDEFAULT_ADMIN(),
				bundle.getRioga().getUserResource().getSystemClient());
//    JSONArray valueArray = retrieveNodesFromKnowledgeAsJSONArray("match (n:ACTIVE&" + Neo4JReqConstant.collab("Objective") + ") return n", "Objectives", user);
//    GJaxbProperty  specificInputEntry = new GJaxbProperty();
//    specificInputEntry.setName("satisfactionProperties");
//    JSONArray finalArray = new JSONArray();
//    JSONObject finalObject = new JSONObject();
//    finalArray.put(finalObject);
//    finalObject.put("name", "objectivesOrder");
//    finalObject.put("value", valueArray);
//    specificInputEntry.setValue(finalArray.toString());
//    JSONObject specificInputObject = new JSONObject();
//    specificInputObject.put("satisfactionProperties", finalArray.toString());

		request.setProcessGeneratorInstance(
				"{\"name\":\"Simple Satisfaction Strategy Process Deduction\",\"class\":\"fr.emac.gind.workflow.deduction.SimpleSatisfactionStrategyDeduction\",\"ng_function_params\":\"{\\\"showInputs\\\":true,\\\"showReport\\\":true,\\\"deploy\\\":false}\",\"favorite_domains\":\"collaborative\"}");
		request.setSpecificInputData(
				"{\"satisfactionProperties\":[{\"name\":\"objectivesOrderMap\",\"value\":\"{\\\"0\\\":[{\\\"brokenEdges\\\":{\\\"brokenEdge\\\":[{\\\"sourceId\\\":\\\"node_873c4aa8-501f-da20-1252-1e5c7b26d089\\\",\\\"edge\\\":{\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"targetPosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"sourcePosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"pathType\\\":\\\"LINE\\\"},{}]}]},\\\"property\\\":[{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"treat\\\"}],\\\"id\\\":\\\"edge_0dd2eba1-f49a-9fbc-af9f-052ffb40ef25\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Treats\\\"},\\\"targetId\\\":\\\"node_7c7b28ce-f64a-4b9d-8f9b-e42c66da4b3f\\\"},{\\\"sourceId\\\":\\\"node_873c4aa8-501f-da20-1252-1e5c7b26d089\\\",\\\"edge\\\":{\\\"property\\\":[{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"near\\\"},{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"}],\\\"id\\\":\\\"edge_8d3215cd-bef1-81ce-ba13-4fa76ec74b87\\\",\\\"type\\\":\\\"{http://fr.emac.gind/core-model}Near\\\"},\\\"targetId\\\":\\\"node_25558168-8bba-76ae-71ae-89a2bcfdddb9\\\"}]},\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"viewId\\\":\\\"view_2a439fdf-2c3e-7484-776e-970b1b827626\\\",\\\"position\\\":{\\\"x\\\":728,\\\"y\\\":965},\\\"dimension\\\":{\\\"width\\\":48,\\\"height\\\":48}}]}]},\\\"extends\\\":[\\\"{http://fr.emac.gind/core-model}Semantic_Concept\\\"],\\\"property\\\":[{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"},{\\\"name\\\":\\\"labels\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"infer by\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"priority\\\",\\\"value\\\":\\\"0\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"Establish security perimeter\\\"},{\\\"name\\\":\\\"use volunteers\\\",\\\"value\\\":\\\"no\\\"}],\\\"id\\\":\\\"node_873c4aa8-501f-da20-1252-1e5c7b26d089\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Objective\\\",\\\"status\\\":[\\\"ACTIVE\\\"],\\\"geolocation\\\":{\\\"itemView\\\":[{\\\"redesign\\\":null,\\\"point\\\":{\\\"image\\\":\\\"/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/objective.svg\\\"}}]}}],\\\"1\\\":[{\\\"brokenEdges\\\":{\\\"brokenEdge\\\":[{\\\"sourceId\\\":\\\"node_6be79fe8-ea75-636d-5214-bdb116d6b16b\\\",\\\"edge\\\":{\\\"property\\\":[{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"near\\\"},{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"}],\\\"id\\\":\\\"edge_7a9fc906-f237-c3d5-d90a-718e6fd3c1d5\\\",\\\"type\\\":\\\"{http://fr.emac.gind/core-model}Near\\\"},\\\"targetId\\\":\\\"node_86d38065-a3f3-392d-4ba6-000abac7c6af\\\"},{\\\"sourceId\\\":\\\"node_6be79fe8-ea75-636d-5214-bdb116d6b16b\\\",\\\"edge\\\":{\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"targetPosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"sourcePosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"pathType\\\":\\\"LINE\\\"},{}]}]},\\\"property\\\":[{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"treat\\\"}],\\\"id\\\":\\\"edge_97615512-5f1f-1cf5-4443-2c662e171b88\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Treats\\\"},\\\"targetId\\\":\\\"node_7c7b28ce-f64a-4b9d-8f9b-e42c66da4b3f\\\"}]},\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"viewId\\\":\\\"view_f33cf037-a9fe-b071-85d8-89e1a351893a\\\",\\\"position\\\":{\\\"x\\\":961,\\\"y\\\":297},\\\"dimension\\\":{\\\"width\\\":48,\\\"height\\\":48}}]}]},\\\"extends\\\":[\\\"{http://fr.emac.gind/core-model}Semantic_Concept\\\"],\\\"property\\\":[{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"},{\\\"name\\\":\\\"labels\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"infer by\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"priority\\\",\\\"value\\\":\\\"0\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"Evacuate the injured\\\"},{\\\"name\\\":\\\"use volunteers\\\",\\\"value\\\":\\\"no\\\"}],\\\"id\\\":\\\"node_6be79fe8-ea75-636d-5214-bdb116d6b16b\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Objective\\\",\\\"status\\\":[\\\"ACTIVE\\\"],\\\"geolocation\\\":{\\\"itemView\\\":[{\\\"redesign\\\":null,\\\"point\\\":{\\\"image\\\":\\\"/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/objective.svg\\\"}}]}}],\\\"2\\\":[{\\\"brokenEdges\\\":{\\\"brokenEdge\\\":[{\\\"sourceId\\\":\\\"node_359dd3aa-f9df-f1d2-950a-2f100b8f7235\\\",\\\"edge\\\":{\\\"property\\\":[{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"near\\\"},{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"}],\\\"id\\\":\\\"edge_29547043-90fb-51c5-b10a-751966e09f49\\\",\\\"type\\\":\\\"{http://fr.emac.gind/core-model}Near\\\"},\\\"targetId\\\":\\\"node_f9ab2411-0632-2b41-d880-dbb45b0a5dc7\\\"},{\\\"sourceId\\\":\\\"node_359dd3aa-f9df-f1d2-950a-2f100b8f7235\\\",\\\"edge\\\":{\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"targetPosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"sourcePosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"pathType\\\":\\\"LINE\\\"},{}]}]},\\\"property\\\":[{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"treat\\\"}],\\\"id\\\":\\\"edge_07cc4fc1-75fd-e845-d620-c8f5f11390ba\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Treats\\\"},\\\"targetId\\\":\\\"node_7c7b28ce-f64a-4b9d-8f9b-e42c66da4b3f\\\"}]},\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"viewId\\\":\\\"view_1179cf8a-ca8d-7044-833a-4703c7855951\\\",\\\"position\\\":{\\\"x\\\":681,\\\"y\\\":11},\\\"dimension\\\":{\\\"width\\\":48,\\\"height\\\":48}}]}]},\\\"extends\\\":[\\\"{http://fr.emac.gind/core-model}Semantic_Concept\\\"],\\\"property\\\":[{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"},{\\\"name\\\":\\\"labels\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"infer by\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"priority\\\",\\\"value\\\":\\\"0\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"Evacuate the people\\\"},{\\\"name\\\":\\\"use volunteers\\\",\\\"value\\\":\\\"no\\\"}],\\\"id\\\":\\\"node_359dd3aa-f9df-f1d2-950a-2f100b8f7235\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Objective\\\",\\\"status\\\":[\\\"ACTIVE\\\"],\\\"geolocation\\\":{\\\"itemView\\\":[{\\\"redesign\\\":null,\\\"point\\\":{\\\"image\\\":\\\"/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/objective.svg\\\"}}]}}],\\\"3\\\":[{\\\"brokenEdges\\\":{\\\"brokenEdge\\\":[{\\\"sourceId\\\":\\\"node_0338668c-95c6-b1af-69cb-7192f383a913\\\",\\\"edge\\\":{\\\"property\\\":[{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"near\\\"},{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"}],\\\"id\\\":\\\"edge_b7f16cde-71b6-aefc-ca64-f152277a08c6\\\",\\\"type\\\":\\\"{http://fr.emac.gind/core-model}Near\\\"},\\\"targetId\\\":\\\"node_1f3d2f7b-f766-25ad-5248-df73e75ec005\\\"},{\\\"sourceId\\\":\\\"node_0338668c-95c6-b1af-69cb-7192f383a913\\\",\\\"edge\\\":{\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"targetPosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"sourcePosition\\\":{\\\"position\\\":{\\\"x\\\":0,\\\"y\\\":0}},\\\"pathType\\\":\\\"LINE\\\"},{}]}]},\\\"property\\\":[{\\\"name\\\":\\\"accuracy\\\",\\\"value\\\":\\\"100\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"treat\\\"}],\\\"id\\\":\\\"edge_643bf219-1540-8de0-6753-d1ec1497a485\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Treats\\\"},\\\"targetId\\\":\\\"node_7c7b28ce-f64a-4b9d-8f9b-e42c66da4b3f\\\"}]},\\\"modeling\\\":{\\\"package\\\":[{\\\"name\\\":\\\"Objectives\\\",\\\"itemView\\\":[{\\\"viewId\\\":\\\"view_9e506221-0b31-60e0-23ac-372982757562\\\",\\\"position\\\":{\\\"x\\\":954,\\\"y\\\":143},\\\"dimension\\\":{\\\"width\\\":48,\\\"height\\\":48}}]}]},\\\"extends\\\":[\\\"{http://fr.emac.gind/core-model}Semantic_Concept\\\"],\\\"property\\\":[{\\\"name\\\":\\\"description\\\",\\\"value\\\":\\\"\\\"},{\\\"name\\\":\\\"labels\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"infer by\\\",\\\"value\\\":\\\"[]\\\"},{\\\"name\\\":\\\"priority\\\",\\\"value\\\":\\\"0\\\"},{\\\"name\\\":\\\"name\\\",\\\"value\\\":\\\"Treat the wounded\\\"},{\\\"name\\\":\\\"use volunteers\\\",\\\"value\\\":\\\"no\\\"}],\\\"id\\\":\\\"node_0338668c-95c6-b1af-69cb-7192f383a913\\\",\\\"type\\\":\\\"{http://fr.emac.gind/collaborative-model}Objective\\\",\\\"status\\\":[\\\"ACTIVE\\\"],\\\"geolocation\\\":{\\\"itemView\\\":[{\\\"redesign\\\":null,\\\"point\\\":{\\\"image\\\":\\\"/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/objective.svg\\\"}}]}}]}\"},{\"name\":\"selectedPlanningSolver\",\"value\":\"Default\"},{\"name\":\"activeMoveImprover\",\"value\":\"true\"}]}");

		// Deduce process
		try {
//			GJaxbDeductionReports res = JSONJAXBContext.getInstance().unmarshall(bundle.getRioga()
//					.getResourcesManager().findResource(ProcessResource.class).deduceProcess(user, request),
//					GJaxbDeductionReports.class);
//			return res.getDeductionReport().get(0).getDeductionResult().getGenericModel();
			return null;
		} catch (Exception e) {
			return null;
		}
	}

	@Test
	@Override
	public void generateProcess_usingSatisfactionStrategy() throws Exception {
		super.generateProcess_usingSatisfactionStrategy();
	}



}
