/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.usecases.iosuite.golfech.crisis.case1;

import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.usecase.GJaxbModelURLType;
import fr.emac.gind.usecase.GJaxbResourceType;
import fr.emac.gind.usecase.GJaxbResourceURLType;
import fr.emac.gind.usecases.RIOAbstractProject;

public class RIOUCGolfechCrisisCase1 extends RIOAbstractProject {

	public RIOUCGolfechCrisisCase1() throws Exception {
		super("./src/test/resources/deduction/request/case1/golfech_crisis");
	}

	@Override
	public void beforeInit() throws Exception {

	}

	@Override
	public void afterInit() throws Exception {
		for (GJaxbResourceURLType rsc : this.getMap().get(GJaxbResourceType.MODEL)) {
			GJaxbModelURLType m = (GJaxbModelURLType) rsc;
			if (m.getResourceType() == GJaxbResourceType.MODEL && m.getStatus() == GJaxbStatusType.ACTIVE
					&& m.getName().contains("collaborative process")) {
				m.setSelected(false);
			}
	
		}
	}

}
