/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.usecases.iosuite.golfech.crisis.case1;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;
import org.junit.jupiter.api.MethodOrderer.MethodName;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.rio.dw.resources.gov.bo.DeduceInput;
import fr.emac.gind.usecase.GJaxbResourceType;
import fr.emac.gind.usecase.GJaxbResourceURLType;
import fr.emac.gind.usecases.RIOAbstractProject;
import fr.emac.gind.usecases.riosuite.test.RIOSuiteDeductionTest;

/**
 * Unit test for simple App.
 */
/**
 *
 *
 * @author Nicolas Salatge
 */
@TestMethodOrder(MethodName.class)
public class UCGolfechCrisisDeductionCase1Test extends RIOSuiteDeductionTest {

	private static final Logger LOG = LoggerFactory.getLogger(UCGolfechCrisisDeductionCase1Test.class.getName());

	public UCGolfechCrisisDeductionCase1Test() throws Exception {
		super(new RIOUCGolfechCrisisCase1()); // TODO Change to access by resource
	}

	@Override
	protected void modifyUsecaseForSpecificCase(RIOAbstractProject uc) throws MalformedURLException, Exception {

		// DELETE ALL SENSORS
		List<GJaxbResourceURLType> modelsResources = uc.getMap().get(GJaxbResourceType.MODEL);
		GJaxbResourceURLType ctxtRsc = null;
		for (GJaxbResourceURLType urlM : modelsResources) {
			System.out.println("urlM: " + urlM.getName());
			if (urlM.getName().equals("context and partners")) {
				ctxtRsc = urlM;
				break;
			}
		}
		if (ctxtRsc != null) {
			GJaxbGenericModel ctxtModel = XMLJAXBContext.getInstance()
					.unmarshallDocument(URI.create(ctxtRsc.getUrl()).toURL(), GJaxbGenericModel.class);
			List<GJaxbNode> sensors = GenericModelHelper.findNodesByType(GenericModelHelper.core("Sensor"),
					ctxtModel.getNode());

			for (GJaxbNode sensor : sensors) {
				ctxtModel.getEdge().removeIf(e -> e.getSource().getId().equals(sensor.getId()));
				ctxtModel.getEdge().removeIf(e -> e.getTarget().getId().equals(sensor.getId()));
			}
			ctxtModel.getNode().removeIf(n -> n.getType().equals(GenericModelHelper.core("Sensor")));
			
			String buffer = XMLPrettyPrinter.print(XMLJAXBContext.getInstance().marshallAnyElement(ctxtModel), "UTF-8");
			FileUtil.setContents(new File(URI.create(ctxtRsc.getUrl())), buffer);
		}
	}

	@Override
	public GJaxbGenericModel doGenerateProcess_usingSatisfactionStrategy(DeduceInput deduceInput) throws Exception {

		// Add specific parameters to request
		LOG.debug("add specific arguments");
		bundle.getRioga().getUserResource();
		DWUser user = new DWUser(SystemResource.getDEFAULT_ADMIN(),
				bundle.getRioga().getUserResource().getSystemClient());

		List<List<GJaxbProperty>> tableProps = new ArrayList<List<GJaxbProperty>>();
		List<GJaxbProperty> rowProps = new ArrayList<GJaxbProperty>();
		rowProps.add(GenericModelHelper.createProperty("selectedPlanningSolver", "Default"));
		rowProps.add(GenericModelHelper.createProperty("potentialitiesManagement",
				"{\"simplePotentialitiesManagement\":{\"potentiality\":[]}}"));

		JSONObject deduceInputObject = new JSONObject(
				FileUtil.getContents(new File("./src/test/resources/deduction/request/case1/deductionRequest_1.json")));
		deduceInput.setProcessGeneratorInstance(deduceInputObject.get("processGeneratorInstance").toString());
		deduceInput.setSpecificInputData(deduceInputObject.get("specificInputData").toString());

		System.out.println("deduceInputObject: \n" + deduceInputObject);

		// deduce process
		LOG.debug("deduce process");
//		String buffer = bundle.getRioga().getResourcesManager().findResource(ProcessResource.class).deduceProcess(user,
//				deduceInput);
//		GJaxbDeductionReports res = JSONJAXBContext.getInstance().unmarshall("{ \"reports\": " + buffer + "}",
//				GJaxbDeductionReports.class);
//
//		// specific assertion
//		LOG.debug("specific assertion");
//		Assertions.assertEquals(1.0,
//				res.getDeductionReport().get(0).getDeductionResult().getDeductionAnalyticReport().getPertinenceIndice(),
//				0.03);
//
//		// return process
//		LOG.debug("return process");
//		return res.getDeductionReport().get(0).getDeductionResult().getGenericModel();
		
		return null;
	}

}
