/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Sébastien REBIERE
 */
package fr.emac.gind.usecases.hellohealth;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;
import org.junit.jupiter.api.MethodOrderer.MethodName;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.rio.dw.resources.gov.bo.DeduceInput;
import fr.emac.gind.usecases.iosuite.hellohealth.RIOUCHellohealth;
import fr.emac.gind.usecases.riosuite.test.RIOSuiteDeductionTest;

/**
 * Unit test for simple App.
 */
/**
 *
 *
 * @author Nicolas Salatge
 */
@TestMethodOrder(MethodName.class)
public class UCHhellohealthDeductionTest extends RIOSuiteDeductionTest {
  
  
  private static final Logger LOG = LoggerFactory.getLogger(UCHhellohealthDeductionTest.class.getName());


  public UCHhellohealthDeductionTest() throws Exception {
    super(new RIOUCHellohealth()); //TODO Change to access by resource
  }


  @Override
  public GJaxbGenericModel doGenerateProcess_usingSatisfactionStrategy(DeduceInput deduceInput) throws Exception {

    // Add specific parameters to request
    LOG.debug("add specific arguments");
      bundle.getRioga().getUserResource();
      DWUser user = new DWUser(SystemResource.getDEFAULT_ADMIN(), bundle.getRioga().getUserResource().getSystemClient());
    

    List<List<GJaxbProperty>> tableProps = new ArrayList<List<GJaxbProperty>>();
    List<GJaxbProperty> rowProps = new ArrayList<GJaxbProperty>();
    rowProps.add(GenericModelHelper.createProperty("selectedPlanningSolver", "Default"));
    rowProps.add(GenericModelHelper.createProperty("potentialitiesManagement", "{\"simplePotentialitiesManagement\":{\"potentiality\":[]}}"));
    
    
    
    
    JSONObject deduceInputObject = new JSONObject(FileUtil.getContents(new File("./src/test/resources/deduction/request/deductionRequest_1.json")));
    deduceInput.setProcessGeneratorInstance(deduceInputObject.get("processGeneratorInstance").toString());
    deduceInput.setSpecificInputData(deduceInputObject.get("specificInputData").toString());
     
    System.out.println("deduceInputObject: \n" + deduceInputObject);
    
    // deduce process
    LOG.debug("deduce process");
//    String buffer = bundle.getRioga().getResourcesManager().findResource(ProcessResource.class).deduceProcess(user, deduceInput);
//    GJaxbDeductionReports res = JSONJAXBContext.getInstance().unmarshall("{ \"reports\": " + buffer + "}", GJaxbDeductionReports.class);
//
//    // specific assertion
//    LOG.debug("specific assertion");
//    Assertions.assertEquals(1.0, res.getDeductionReport().get(0).getDeductionResult().getDeductionAnalyticReport().getPertinenceIndice(), 0.03);
//
//    // return process
//    LOG.debug("return process");
//    return res.getDeductionReport().get(0).getDeductionResult().getGenericModel();
    return null;
  } 


}
