/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: josepe
 */
package fr.emac.gind.usecases.riosuite.test;

/*
 * #%L
 * usecases-orkid-test
 * %%
 * Copyright (C) 2014 - 2017 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.process.instance.GJaxbRunASync;
import fr.emac.gind.process.instance.GJaxbRunASyncResponse;
import fr.emac.gind.process.instance.GJaxbRunSync;
import fr.emac.gind.process.instance.GJaxbRunSyncResponse;
import fr.emac.gind.process.instance.ProcessInstance;
import fr.emac.gind.process.instance.RunASyncFault;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHeader;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.usecases.riosuite.test.partners.PartnerEvaluatorTest;
import fr.emac.gind.workflow.engine.Engine;
import fr.emac.gind.workflow.engine.WSWorkflowProcess;
import fr.emac.gind.workflow.engine.WorkflowContainer;
import fr.emac.gind.workflow.engine.expression.xpath.XPathExpressionEvaluator;
import fr.emac.gind.workflow.engine.message.Message;
import fr.emac.gind.workflow.engine.message.binding.soap.SoapBindingInputMessageAdapter;
import fr.emac.gind.workflow.engine.message.binding.soap.SoapBindingOutputMessageAdapter;
import fr.emac.gind.workflow.engine.prio.compiler.PRIOCompiler;
import fr.emac.gind.wsdl11.WSDLDefinitionsManager;
import jakarta.xml.bind.JAXBContext;

public abstract class AbstractRIOProcess implements ProcessInstance {

  protected Engine engine;
  protected WSWorkflowProcess receiver;
  protected fr.emac.gind.workflow.engine.Process process;
  private final int timeoutExecutionProcess;


  public AbstractRIOProcess(URL gemUrl, URL[] otherFiles, String collaborationName, String knowledgeSpaceName) throws Exception {
    this(gemUrl, null, otherFiles, collaborationName, knowledgeSpaceName);
  }
  public AbstractRIOProcess(URL gemUrl, String strategyName, URL[] otherFiles, String collaborationName, String knowledgeSpaceName) throws Exception {

    PRIOCompiler compiler = new PRIOCompiler();
    compiler.init(new XPathExpressionEvaluator(), new PartnerEvaluatorTest(), SoapBindingInputMessageAdapter.class, SoapBindingOutputMessageAdapter.class);

    Configuration conf = new Configuration(Thread.currentThread().getContextClassLoader().getResource("conf/config.properties"));
    Configuration confWSContainer = new Configuration(Thread.currentThread().getContextClassLoader().getResource("test/conf/generated/workflow-container/conf/config.properties"));
    this.timeoutExecutionProcess = Integer.valueOf((String)confWSContainer.getMapObjects().get("timeout-execution-process"));
    engine = new Engine((Map)conf.getProperties(), compiler);
    process = engine.compile(gemUrl, Thread.currentThread().getContextClassLoader().getResource("wsdl/DefaultProcess.wsdl"), collaborationName, knowledgeSpaceName, otherFiles)[0];
    WSDLDefinitionsManager manager = new WSDLDefinitionsManager(process.getWsdl());
    QName serviceQName = new QName(manager.getServices()[0].findTargetNamespace(), manager.getServices()[0].getName());
    WorkflowContainer container = new WorkflowContainer();
    container.setEngine(engine);
    receiver = new WSWorkflowProcess("runSyncResponse", serviceQName, manager.getServices()[0].getPort().get(0).getName(), container);
    
  }


  public Engine getEngine() {
    return engine;
  }

  public fr.emac.gind.workflow.engine.Process getProcess() {
    return process;
  }

  @Override
  public GJaxbRunSyncResponse runSync(GJaxbRunSync parameters) {
    try {
      final Message msg = new Message(new QName("http://www.gind.emac.fr/process/instance", "runSyncRequest"), process.getWsdlManger().getServices()[0].getPort().get(0).getName()); 
      JAXBContext jc = JAXBContext.newInstance(fr.emac.gind.process.instance.ObjectFactory.class);
      Document doc = DOMUtil.getInstance().newDocument();
      jc.createMarshaller().marshal(parameters, doc);

      SOAPHeader header = new SOAPHeader(new HashMap<QName , String>() {{
        put(new QName("http://fr.emac.gind/", "withoutThread"), "true");
      }});


      Document soapRequest = SOAPSender.createSOAPMessageRequest(doc, header);

      msg.setPayload(soapRequest);


      Map<String, Object> context = new HashMap<String, Object>();
      context.put("soapHeader", header);
      context.put("messageQName", new QName("http://www.gind.emac.fr/process/instance", "runSyncRequest"));
      return receiver.acceptSync(parameters, context);

      // Execution execution = engine.accept(msg);
      // execution.lockOnEndedProcess(timeoutExecutionProcess);

      //      Element elmt = (Element) execution.getVariableValue("runSyncResponse").getValue();
      //      if(elmt == null) {
      //        elmt = XMLJAXBContext.getInstance().marshallAnyElement(new GJaxbRunSyncResponse()).getDocumentElement();;
      //      }
      //
      //      JAXBElement<GJaxbRunSyncResponse> response = jc.createUnmarshaller().unmarshal(DOMUtil.getInstance().createDocumentFromElement(elmt), GJaxbRunSyncResponse.class);
      //
      //      return response.getValue();
    } catch(Exception e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    } catch (Throwable e) {
      throw new RuntimeException(e);
    }
  }


  @Override
  public GJaxbRunASyncResponse runASync(GJaxbRunASync parameters)
      throws RunASyncFault {
    // TODO Auto-generated method stub
    return null;
  }




}
