/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.usecases.riosuite.test;

import java.util.Map;
import java.util.Map.Entry;

import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.humantask.GJaxbAddHumanTaskEvent;
import fr.emac.gind.humantask.GJaxbTask;
import fr.emac.gind.humantask.GJaxbUpdateTask;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.rio.dw.resources.HumanTaskResource;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;


@WebService(
		serviceName = "NotifierClientService",
		portName = "NotifierClientEndpoint",
		targetNamespace = "http://www.gind.emac.fr/notifier",
		wsdlLocation = "/wsdl/notifier.wsdl",
		endpointInterface = "fr.emac.gind.notifier.NotifierClient")
public class HumanTaskTestNotifierClient extends AbstractNotifierClient {

	private static final Logger LOG = LoggerFactory.getLogger(HumanTaskTestNotifierClient.class.getName());

	private Map<String, Entry<String, String>> humanAnswers = null;
	private DWUser user = null;
	private RIOSuiteAbstractBundle bundle = null;

	public HumanTaskTestNotifierClient(String address, Map<String, Entry<String, String>> humanAnswers, DWUser user, RIOSuiteAbstractBundle bundle) throws Exception {
		super(address);
		this.humanAnswers = humanAnswers;
		this.user = user;
		this.bundle = bundle;
	}

	public void notify(GJaxbNotify notify) {
		try {

			GJaxbTask ht = null;
			Document msg = WSNHelper.getInstance().getFirstMessageInNotification(notify);
			LOG.debug("ADD HUMAN TASK EVENT ? " + msg.getDocumentElement().getLocalName());
			if(msg.getDocumentElement().getLocalName().equals("addHumanTaskEvent") && msg.getDocumentElement().getNamespaceURI().equals("http://www.gind.emac.fr/humantask")) {
				GJaxbAddHumanTaskEvent me =  XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbAddHumanTaskEvent.class);
				ht = me.getTask();
				Entry<String, String> answers = humanAnswers.get(GenericModelHelper.getName(ht.getNode()));
				LOG.debug("Task name to seek in map " + GenericModelHelper.getName(ht.getNode()));
				String acceptResponse = answers.getKey();
				String achievedResponse = answers.getValue();
				performHumanTask(ht, user, acceptResponse, achievedResponse);
			} 
		}catch(Exception e) {
			e.printStackTrace();
			Assertions.fail();
		}
	}

	protected void performHumanTask(GJaxbTask t, DWUser user, String acceptResponse, String achievedResponse) {
		try {
			LOG.debug("RECEIVING TASK " + GenericModelHelper.getName(t.getNode()));
			LOG.debug(JSONJAXBContext.getInstance().marshallAnyElement(t.getNode()));
			GJaxbUpdateTask updateRequest = new GJaxbUpdateTask();
			GJaxbProperty acceptance = GenericModelHelper.findProperty("Acceptance", t.getNode().getProperty(), true);
			GJaxbProperty achieved = GenericModelHelper.findProperty("Achieved", t.getNode().getProperty(), true);
			acceptance.setValue(acceptResponse);
			achieved.setValue(achievedResponse);
			updateRequest.setTask(t);
			updateRequest.setCollaborationName(user.getCurrentCollaborationName());
			updateRequest.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
			updateRequest.setDeployedTaskId(t.getDeployedTaskId());
			LOG.debug("UPDATING TASK " + GenericModelHelper.getName(t.getNode()));
			bundle.getRioga().getResourcesManager().findResource(HumanTaskResource.class).updateTask(user, updateRequest);
			//Thread.sleep(2000);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			LOG.debug("PROBLEM UPDATING TASK");
			e.printStackTrace();
		}
	}
}
