/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: josepe
 */
package fr.emac.gind.usecases.riosuite.test;

import java.io.File;

/*
 * #%L
 * workflow-engine-prk
 * %%
 * Copyright (C) 2014 - 2015 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

import fr.emac.gind.bootstrap.test.GindTest;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaign;
import fr.emac.gind.campaign.manager.data.model.GJaxbProcessToDeploy;
import fr.emac.gind.campaign.manager.data.model.GJaxbResourceType;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import fr.emac.gind.process.instance.GJaxbExecType;
import fr.emac.gind.process.instance.GJaxbRunSync;
import fr.emac.gind.process.instance.GJaxbRunSyncResponse;
import fr.emac.gind.process.instance.ProcessInstance;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHeader;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.workflow.engine.Engine;
import fr.emac.gind.workflow.engine.Execution;
import fr.emac.gind.workflow.engine.Execution.Status;
import fr.emac.gind.workflow.engine.Process;
import fr.emac.gind.workflow.engine.message.Message;
import fr.emac.gind.workflow.engine.message.ParametersUtil;
import fr.emac.gind.workflow.engine.prio.compiler.PRIOCompiler;
import fr.emac.gind.workflow.engine.prio.utils.ProcessInstanceIndicatorHelper;
import jakarta.xml.ws.Endpoint;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class PRIOTest extends GindTest {

  private static final Logger LOG = LoggerFactory.getLogger(PRIOTest.class.getName());

  private final SOAPSender sender = new SOAPSender();
  private File processPrio = null;
  protected URL riskUrl = null;
  protected URL projectUrl = null;
  private final List<Scenario> scenarios = new ArrayList<Scenario>();
  private String serverAddress = null;
  private Class<? extends ProcessInstance> engineClass = null;
  protected URL[] otherFiles = null;
  protected String rangeStrategyName = null;



  public PRIOTest(File processXml, String rangeStrategyName, String serverAddress, Class<? extends ProcessInstance> engineClass, URL... otherFiles) throws Exception {
    this.otherFiles = otherFiles;
    this.rangeStrategyName = rangeStrategyName;
   
    riskUrl = Arrays.asList(this.otherFiles).stream().filter(u -> u.toString().endsWith("objectives.xml")).findAny().get();
    projectUrl = Arrays.asList(this.otherFiles).stream().filter(u -> u.toString().endsWith("project.xml")).findAny().get();
    assert projectUrl != null;
    
    if(rangeStrategyName != null) {
      this.processPrio = new File("./target/process_"+rangeStrategyName+ ".prio");
//      IndicatorsRangeStrategyPluginManager indicatorStrategyManager = new IndicatorsRangeStrategyPluginManager();
//      indicatorStrategyManager.getRangeStrategies();
      GJaxbGenericModel originalProcess = XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().parse(processXml), GJaxbGenericModel.class);
    
      Document dom = XMLJAXBContext.getInstance().marshallAnyElement(originalProcess);
      File newProcessFile = File.createTempFile("newProcess",rangeStrategyName);
      FileUtil.setContents(newProcessFile, XMLPrettyPrinter.print(dom));

      FileUtils.copyFile(newProcessFile, processPrio);

    } else {
      this.processPrio = new File("./target/process.prio");
      FileUtils.copyFile(processXml, processPrio);
    }

    this.engineClass = engineClass;
    this.serverAddress = serverAddress;
    GJaxbCampaign campaign = new GJaxbCampaign();
//    campaign.setExperimentalPlan(new GJaxbExperimentalPlan());
//    campaign.getExperimentalPlan().setPotentialitiesManagement(new GJaxbPotentialitiesManagement());
//    campaign.getExperimentalPlan().getPotentialitiesManagement().setMultiplePotentialitiesManagement(new GJaxbMultiplePotentialitiesManagement());
//    campaign.getExperimentalPlan().getPotentialitiesManagement().getMultiplePotentialitiesManagement().setPreventivesOnly(true);
//    campaign.getExperimentalPlan().getPotentialitiesManagement().getMultiplePotentialitiesManagement().setCorrectivesOnly(true);
//    campaign.getExperimentalPlan().getPotentialitiesManagement().getMultiplePotentialitiesManagement().setPreventivesAndCorrectives(true);
    GJaxbProcessToDeploy pd = new GJaxbProcessToDeploy();
    GJaxbResourceType processResource = new GJaxbResourceType();
    GJaxbGenericModel processModel = XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().parse(this.processPrio), GJaxbGenericModel.class);
    GenericModelManager processModelManager = new GenericModelManager(processModel);
    processResource.setGenericModel(processModel);
    processResource.setName("processName");
    pd.setProcess(processResource);
    
//    GJaxbInputRequest input = new GJaxbInputRequest();
//    pd.getInputRequest().add(input);
//    
//    campaign.setSolution();
//    campaign.setProcessesToDeploy(new SolutionToDeploy());
//    
//    AnotherProcess aProc = new AnotherProcess();
//    ProcessVariant pv = new ProcessVariant();
//    aProc.getProcessVariant().add(pv);
//    pv.setProcessToDeploy(pd);
//    campaign.getProcessesToDeploy().getAnotherProcess().add(aProc);
//    
//    
//    SelectedProcess sp = new SelectedProcess();
//    sp.setId(processModelManager.getNodesByType(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Process")).get(0).getId());
//    campaign.getExperimentalPlan().getSelectedProcess().add(sp);
    // campaign.getExperimentalPlan().getRisksManagement().setMaxNumberOfRisksActivated("1");
  }

  public void addScenario(Scenario scenario) {
    this.scenarios.add(scenario);
  }


  @Test
  public void excuteAllScenariosWithoutThread() throws Exception {
    for(Scenario scenario: scenarios) {
      try {

        LOG.info("Run scenario (" + (scenarios.indexOf(scenario)+1) + "/" + scenarios.size() + ") : " + scenario.getName() + " ( expectedDuration = " + scenario.getExpectedDuration() + ", expectedCost = " + scenario.getExpectedCost() + ", expectedProbability = " + scenario.getExpectedProbability() + " )");
        executeTestWithoutThreadWithParam(scenario); 
        LOG.info("Scenario (" + (scenarios.indexOf(scenario)+1) + "/" + scenarios.size() + ") : " + scenario.getName() + " => Successfull !!!");
      } catch(Throwable e) {

        LOG.error("Scenario (" + (scenarios.indexOf(scenario)+1) + "/" + scenarios.size() + ") : "  + scenario.getName() + " => Failed !!!");
        throw e;
      }
    }
  }

  @Test
  public void excuteAllScenariosWS() throws Exception {
    for(Scenario scenario: scenarios) {
      try {

        LOG.info("Run scenario (" + (scenarios.indexOf(scenario)+1) + "/" + scenarios.size() + ") : "  + scenario.getName() + " ( expectedDuration = " + scenario.getExpectedDuration() + ", expectedCost = " + scenario.getExpectedCost() + ", expectedProbability = " + scenario.getExpectedProbability() + " )");
        executeTestWSWithParam(scenario); 
        LOG.info("Scenario (" + (scenarios.indexOf(scenario)+1) + "/" + scenarios.size() + ") : " + scenario.getName() + " => Successfull !!!");
      } catch(Throwable e) {

        LOG.error("Scenario (" + (scenarios.indexOf(scenario)+1) + "/" + scenarios.size() + ") : " + scenario.getName() + " => Failed !!!");
        throw e;
      }
    }
  }
  
  private Execution executeTestWithoutThreadWithoutImpedanceAssert(Scenario scenario ) throws Exception {
    PRIOCompiler compiler = new PRIOCompiler();
    Configuration conf = new Configuration(Thread.currentThread().getContextClassLoader().getResource("conf/config.properties"));
    Engine engine = new Engine((Map)conf.getProperties(), compiler);
    compiler.initByDefault();


    Process[] processus = compiler.compile(this.processPrio.toURI().toURL(), Thread.currentThread().getContextClassLoader().getResource("wsdl/ProcessInstance.wsdl"), otherFiles, null, null); //Arrays.asList(this.risk).toArray(new URL[1]));
    Process process = processus[0];

    final Message msg = new Message(new QName("http://www.gind.emac.fr/ProcessInstance/", "runSyncRequest"), process.getWsdlManger().getServices()[0].getPort().get(0).getName()); 
    GJaxbRunSync request = new GJaxbRunSync();
    request.setExecutionType(GJaxbExecType.SIMULATION);

    JSONArray selectedImpedances = buildImpedancesSelected("cost", "duration");

    request.getParameter().add(ParametersUtil.createParameter("selectedImpedances", selectedImpedances));
    request.getParameter().add(ParametersUtil.createParameter("potentialities", scenario.getRisks()));
    request.getParameter().add(ParametersUtil.createParameter("preventiveStrategies", scenario.getPreventiveStrategies()));
    request.getParameter().add(ParametersUtil.createParameter("correctiveStrategies", scenario.getCorrectiveStrategies()));
    request.getParameter().add(ParametersUtil.createParameter("breakpoints", List.of()));
    request.getParameter().add(ParametersUtil.createParameter("rangeStrategyName", this.rangeStrategyName));

    Map<QName, String> mapOfHeaders = Map.of(new QName("http://fr.emac.gind/", "withoutThread"), "true");
    SOAPHeader header = new SOAPHeader(mapOfHeaders);
    Document soapRequest = SOAPSender.createSOAPMessageRequest(XMLJAXBContext.getInstance().marshallAnyElement(request), header);

    msg.setPayload(soapRequest);

    final Execution execution = engine.createExecution(process);
    execution.bindMessageToVariable(process, msg);
    execution.getContext().put("inputRequest", request);
    Assertions.assertEquals(Status.INACTIVE, execution.getStatus());

    execution.runWithoutThread(); 
    validExecution(execution);

//    LOG.debug("probability  : "+ (Double) execution.getContext().get("process_" + "probability")+" \texpected: "+scenario.getExpectedProbability());
    LOG.debug("duration     : "    +  execution.getVariableValue("process_" + "duration").getValue(execution)+" \texpected: "+scenario.getExpectedDuration());
//    LOG.debug("cost         : "+  execution.getContext().get("process_" + "cost")+" \texpected: "+scenario.getExpectedCost());
    
    return execution;
  }

  private void executeTestWithoutThreadWithParam(Scenario scenario) throws Exception {
  
    Execution execution = executeTestWithoutThreadWithoutImpedanceAssert(scenario);
    //Assertions.assertEquals(scenario.getName() + " failed!!!: Error on probability ", scenario.getExpectedProbability(), (Double) execution.getContext().get("process_" + "probability"), 0.001);
    Assertions.assertEquals(scenario.getExpectedDuration(), (Float) execution.getVariableValue("process_" + "duration").getValue(execution), 0.001, scenario.getName() + " failed!!!: Error on duration ");
//    Assertions.assertEquals(scenario.getName() + " failed!!!: Error on cost ", scenario.getExpectedCost(), (Float) execution.getContext().get("process_" + "cost"), 0.001); 


  }

  public static void validExecution(final Execution execution) {
    Assertions.assertEquals(Status.ENDED, execution.getStatus());


    Execution[] ee = execution.getAllChildExecutionsRecursively();
    LOG.debug(execution.getName()+" "+execution.getStatus() + " on node: " + execution.getCurrentNode().getName());
    for(int i=0 ; i < ee.length ; i++) {
      LOG.debug(ee[i].getName()+" "+ee[i].getStatus() + " on node: " + execution.getCurrentNode().getName());
    }
    Assertions.assertEquals(0, Arrays.asList(execution.getAllChildExecutionsRecursively()).stream()
        .filter(ex ->{
          return !ex.getStatus().equals(Status.ENDED);
        })
        .peek(eee -> LOG.debug("PROBLEM WITH THESE EXECUTIONS " + eee.getName() + " " + eee.getStatus()))
        .count());
    if(execution.getAllChildExecutionsRecursively().length>0) {
      Arrays.asList(execution.getAllChildExecutionsRecursively()).forEach(exe -> {
        LOG.debug("PROBLEM WITH " + exe.getName());
      });
    }
    Assertions.assertEquals(0, execution.getAllChildExecutionsRecursively().length);
    Assertions.assertNotNull(execution.getVariableValue("runSyncResponse").getValue(execution));
    Assertions.assertTrue(execution.isProcessCorrectlyEnded());
  }


  private GJaxbRunSyncResponse runProcess(String endpointAddress,
      GJaxbRunSync request) throws Exception {
    GJaxbRunSyncResponse response;
    SOAPHeader header = new SOAPHeader(new HashMap<QName , String>() {{
      put(new QName("http://fr.emac.gind/", "withoutThread"), "true");
    }});
    Document resp =  this.sender.sendSoapRequest(XMLJAXBContext.getInstance().marshallAnyElement(request), endpointAddress, "http://www.gind.emac.fr/ProcessInstance/runSync", header);
    response = XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload(resp), GJaxbRunSyncResponse.class);
    return response;
  }


  private JSONArray buildImpedancesSelected(String...names) {
    JSONArray selectedImpedances = new JSONArray();
    for(int i = 0 ; i < names.length ; i++) {
      JSONObject impedance = new JSONObject();
      impedance.put("name", names[i]);
      impedance.put("selected", true);
      selectedImpedances.put(impedance);
    }

    return selectedImpedances;
  }

  private void executeTestWSWithParam(Scenario scenario) throws Exception {
    AbstractRIOProcess engine = (AbstractRIOProcess) engineClass.getConstructor(URL.class, URL[].class).newInstance(processPrio.toURI().toURL(), otherFiles);
    Endpoint server = Endpoint.publish(this.serverAddress, engine);
    try {
      final Message msg = new Message(new QName("http://www.gind.emac.fr/ProcessInstance/", "runSyncRequest"), engine.getProcess().getWsdlManger().getServices()[0].getPort().get(0).getName()); 
      GJaxbRunSync request = new GJaxbRunSync();
      request.getParameter().add(ParametersUtil.createParameter("calculateDuration", true));
      JSONArray selectedImpedances = buildImpedancesSelected("cost", "duration");

      request.getParameter().add(ParametersUtil.createParameter("selectedImpedances", selectedImpedances));
      request.getParameter().add(ParametersUtil.createParameter("potentialities", scenario.getRisks()));
      request.getParameter().add(ParametersUtil.createParameter("preventiveStrategies", scenario.getPreventiveStrategies()));
      request.getParameter().add(ParametersUtil.createParameter("correctiveStrategies", scenario.getCorrectiveStrategies()));
      request.getParameter().add(ParametersUtil.createParameter("breakpoints", List.of()));
      request.getParameter().add(ParametersUtil.createParameter("rangeStrategyName", this.rangeStrategyName));
      request.setExecutionType(GJaxbExecType.SIMULATION);
      
      Document soapRequest = SOAPSender.createSOAPMessageRequest(XMLJAXBContext.getInstance().marshallAnyElement(request), null);

      msg.setPayload(soapRequest);


      GJaxbRunSyncResponse response = runProcess(this.serverAddress, request);
      Assertions.assertNotNull(response);
      Assertions.assertNotNull(response.getSimulationResults());
      //Assertions.assertEquals(scenario.getName() + " failed!!!: Error on probability ", scenario.getExpectedProbability(), Double.valueOf(response.getSimulationResults().getOpportunityThreatsProbability()));
      LOG.debug("expected duration " + scenario.getExpectedDuration());
      LOG.debug("actual duration   " + ProcessInstanceIndicatorHelper.findIndicator("duration", response.getSimulationResults().getSimulationOutputByProcess().getIndicator()).getIndicatorValue().getSimulatedValue());
 //     LOG.debug("expected cost " + scenario.getExpectedCost());
 //     LOG.debug("actual cost   " + ProcessInstanceIndicatorHelper.findIndicator("cost", response.getSimulationResults().getSimulationOutputByCategoryProcess().getIndicator()).getModel().getProcessValue().getSimulatedValue());
      Assertions.assertEquals(scenario.getExpectedDuration(), Double.valueOf(ProcessInstanceIndicatorHelper.findIndicator("duration", response.getSimulationResults().getSimulationOutputByProcess().getIndicator()).getIndicatorValue().getSimulatedValue().getPrecise()), 0.01, scenario.getName() + " failed!!!: Error on duration ");
//      Assertions.assertEquals(scenario.getName() + " failed!!!: Error on cost ", scenario.getExpectedCost(), Double.valueOf(ProcessInstanceIndicatorHelper.findIndicator("cost", response.getSimulationResults().getSimulationOutputByCategoryProcess().getIndicator()).getModel().getProcessValue().getSimulatedValue()), 0.01);


    } finally {
      if(server !=null) {
        server.stop();
      }
    }
  }



  //////////////
  // Scenario

  @SuppressWarnings({ "unused", "unchecked", "rawtypes" })
  @Test
  public void findNumberOfScenarios() throws Exception {

  }


}
