/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Julien Lesbegueries
 */
package fr.emac.gind.usecases.riosuite.test;


import javax.xml.namespace.QName;

import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer.MethodName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.rio.PluginCollaborativeModel;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.rio.dw.resources.gov.bo.DeduceInput;
import fr.emac.gind.rio.suite.test.RIOSuiteDeductionBundle;
import fr.emac.gind.usecases.RIOAbstractProject;
import fr.emac.gind.workflow.deduction.AbstractDeductionStrategy;
import fr.emac.gind.workflow.deduction.SimpleSatisfactionStrategyDeductionCampaign;
import fr.emac.gind.workflow.report.GJaxbDeductionReport;
import fr.emac.gind.workflow.report.GJaxbErrorReport;

/**
 * Unit test for simple App.
 */
/**
 *
 *
 * @author Nicolas Salatge
 */
@TestMethodOrder(MethodName.class)
public abstract class RIOSuiteDeductionTest extends RIOSuiteTest {

  private static final Logger LOG = LoggerFactory.getLogger(RIOSuiteDeductionTest.class.getName());


  public RIOSuiteDeductionTest(RIOAbstractProject uc) throws Exception {
    super(uc);
  }

  public RIOSuiteDeductionTest initialize() {
    return this;
  }

  public String getStrategy() {
    String ordering = null;
    JSONObject deduction = this.uc.getContext().get("deductionStrategy");
    if(deduction != null) {
      ordering = deduction.getString("priorityOrder");
    }
    return ordering;
  }



  protected void validProcessesWithBasicAssertion(GJaxbDeductionReport report) throws Exception {
    Assertions.assertNotNull(report, "No reports");
    Assertions.assertNotNull(report.getGenericModel()); 
  }


  private void assertProcess(AbstractDeductionStrategy strategy) throws Exception {
    DeduceInput request = generateStrategyRequest(strategy);
    GJaxbGenericModel process = null;
    if(strategy.getName().equals(new SimpleSatisfactionStrategyDeductionCampaign().getName())) {
      process = doGenerateProcess_usingSatisfactionStrategy(request);
    } 
    
   
    if(process != null) {
      LOG.debug("global assertion");
      Assertions.assertTrue(process.getNode().stream().anyMatch(n -> {
        try {
          return EffectiveMetaModelPluginManager.getInstance().inherit(n, new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Task"));
        } catch (Exception e) {
          e.printStackTrace();
          throw new RuntimeException(e);
        } 
      }));
      LOG.debug("save file to earn time");
      generateProcessFile(strategy, process);
    }
  }

  @Override
  protected RIOSuiteAbstractBundle initBundle() throws Exception {
    return new RIOSuiteDeductionBundle();
  }

  
  protected void assertError(GJaxbErrorReport res) {
      Assertions.assertNotNull(res);
  }

  @Test //(timeout=20000)
  public void generateProcess_usingSatisfactionStrategy() throws Exception {
    assertProcess(new SimpleSatisfactionStrategyDeductionCampaign());
  }
  
  
  public abstract GJaxbGenericModel doGenerateProcess_usingSatisfactionStrategy(DeduceInput request) throws Exception;


}
