/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: josepe
 */
package fr.emac.gind.usecases.riosuite.test;

import java.util.HashMap;
import java.util.Map;

import fr.emac.gind.event.broker.EventBrokerWebService;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.io.interpretation.engine.InterpretationEngineContainer;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.rio.suite.test.RIOSuiteInterpretationBundle;
import fr.emac.gind.sensors.manager.SensorManagerClient;
import fr.emac.gind.sensors.manager.SensorManagerWebService;
import fr.emac.gind.storage.client.StorageClient;
import fr.emac.gind.usecases.RIOAbstractProject;

public class RIOSuiteInterpretationRuleTest extends RIOSuiteTest {

  protected InterpretationEngineContainer interpretationEngine = null;
  protected EventBrokerWebService eventBrokerServer = null;
  protected SensorManagerWebService sensorManagerServer = null;

  protected StorageClient storageClient = null;
  protected CoreGovClient coreGovClient = null;
  protected SensorManagerClient epsClient = null;

  protected Map<String, GJaxbNode> sensors = new HashMap<String, GJaxbNode>();

  public RIOSuiteInterpretationRuleTest(RIOAbstractProject uc) throws Exception {
    super(uc);
  }

  @Override
  protected RIOSuiteAbstractBundle initBundle() throws Exception {
    return new RIOSuiteInterpretationBundle();
  }

}
