/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Julien Lesbegueries
 */
package fr.emac.gind.usecases.riosuite.test;


import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer.MethodName;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.campaign.manager.data.model.GJaxbProcessToDeploy;
import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.eventcommonsdata.GJaxbProcessStatusType;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.models_gov.GJaxbSynchronizeResponse;
import fr.emac.gind.humantask.client.HumanTaskClient;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.process.GJaxbDeployResult;
import fr.emac.gind.process.instance.GJaxbExecType;
import fr.emac.gind.process.instance.GJaxbRunASyncResponse;
import fr.emac.gind.process.instance.GJaxbRunSync;
import fr.emac.gind.process.instance.GJaxbRunSync.InputData;
import fr.emac.gind.processmonitoring.data.GJaxbGetProcessInstanceResponse;
import fr.emac.gind.rio.PluginCollaborativeModel;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.rio.dw.resources.gov.ProcessResource;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.rio.dw.resources.gov.bo.RequestHeaderContext;
import fr.emac.gind.rio.dw.resources.gov.bo.RunProcessRequest;
import fr.emac.gind.rio.suite.test.RIOSuiteSimulationAndOrchestrationBundle;
import fr.emac.gind.usecases.RIOAbstractProject;
import fr.emac.gind.workflow.deduction.AbstractDeductionStrategy;
import fr.emac.gind.workflow.report.GJaxbErrorReport;

/**
 * Unit test for simple App.
 *
 *
 * @author Nicolas Salatge
 */
@TestMethodOrder(MethodName.class)
public abstract class RIOSuiteOrchestrationTest extends RIOSuiteTest {

  protected static Logger LOG = LoggerFactory.getLogger(RIOSuiteOrchestrationTest.class.getName());

  public HumanTaskClient htClient;

  private final String callbackAddress;

  private final String port;

  private NotificationConsumerWebService humanTaskconsumer;

  public RIOSuiteOrchestrationTest(RIOAbstractProject uc) throws Exception {
    super(uc);
    this.port = "10108";
    this.callbackAddress = "http://localhost:"+ this.port +"/NotifierTest";
  }

  @BeforeEach
  public void initHumanTaskTestNotifier() {

  }

  @AfterEach
  public void stopHumanTaskTestNotifier() throws Exception {
    if(this.humanTaskconsumer != null) {
      humanTaskconsumer.stop();
    }
  }

  protected <TESTCLASSCREATINGPROCESS extends RIOSuiteTest, STRATEGY extends AbstractDeductionStrategy>  GJaxbRunASyncResponse launchOrchestrationTest(DWUser user, File existingDeducedProcess, TESTCLASSCREATINGPROCESS ucDeduction,
      STRATEGY strategy, Map<String, Entry<String, String>> humanAnswers) throws Exception {
    /**
     * If deduced process file is younger than one hour, we use it instead of re-deduce it
     */
    GJaxbGenericModel process = null;
    if(existingDeducedProcess.exists()) {
      LOG.debug("let's use existing deduced process." + existingDeducedProcess.toURI().toURL());
      process = XMLJAXBContext.getInstance().unmarshallDocument(existingDeducedProcess.toURI().toURL(), GJaxbGenericModel.class);
    } else {
      LOG.debug("Let's deduce the process before running it.");
      throw new Exception("Not Yet Implemented");
    }
    Assertions.assertNotNull(process);
    generateProcessFile(strategy, process);
    /**
     * We publish the process model
     */
    GJaxbRunSync request = new GJaxbRunSync();
    request.setStartDate(XMLGregorianCalendarHelper.getInstance().getNewCalendar(new Date()));
    request.setExecutionType(GJaxbExecType.ORCHESTRATION);

    InputData in = new InputData();
    request.setInputData(in);
    GJaxbSynchronizeResponse publishResponse = bundle.getRioga().getResourcesManager().findResource(ModelsResource.class)
        .publish(user.getCurrentCollaborationName(), user.getCurrentKnowledgeSpaceName(), process, null, null);
    assert publishResponse != null;

    /**
     * We subscribe to humantask
     */
    LOG.debug(createNotifierForHumanTaskEvent(user, humanAnswers));
    //    this.htClient = new HumanTaskClient(bundle.getRioga().getConfiguration().getProperties().get("humantask"));
    //    GJaxbSubscribeTasksByUserResponse sub = bundle.getRioga().getResourcesManager().findResource(HumanTaskResource.class).subscribeToAddTasksByUser(user, user.getUser().getId(),user.getUser().getId(), callbackAddress, this.htClient);
    //    assert sub != null;

    /**
     * We launch the orchestration on the deployed Process
     */
    RunProcessRequest runRequest = new RunProcessRequest();
    RequestHeaderContext requestHeaderContext = new RequestHeaderContext();
    //requestHeaderContext.setOnlyCurrentUser(true);

    GJaxbNode processNode = process.getNode().stream().filter(n -> n.getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Process"))).findAny().get();
    
    GJaxbProcessToDeploy sp = new GJaxbProcessToDeploy();
    sp.setProcessId(processNode.getId());
    sp.setProcessName(GenericModelHelper.getName(processNode));

    GJaxbDeployResult deployResponse = bundle.getRioga().getResourcesManager().findResource(ProcessResource.class).deploy(user, sp);

    String endpointAddress = deployResponse.getEndpointAddress();
    runRequest.setEndpointAddress(endpointAddress);

    runRequest.setProcessToDeploy(sp);
    runRequest.setRequestHeaderContext(requestHeaderContext);

    GJaxbRunASyncResponse res = bundle.getRioga().getResourcesManager().findResource(ProcessResource.class).runASync(user, runRequest);
    assertRunAsyncResponse(res);
    return res;
  }




  public String createNotifierForHumanTaskEvent(DWUser user, Map<String, Entry<String, String>> humanAnswers) throws Exception {

    final String notifierClientAddress = callbackAddress;
    final HumanTaskTestNotifierClient notifier = new HumanTaskTestNotifierClient(notifierClientAddress, humanAnswers, user, bundle);
    humanTaskconsumer = new NotificationConsumerWebService();
    humanTaskconsumer.start(new HashMap<String, Object>(){{put("host","0.0.0.0"); put("port", port); put("serviceName", "NotifierTest"); put("notifierClient", notifier); }});
    LOG.debug("Subscribe on addHumanTaskTopic at " +  bundle.getRioga().getConfiguration().getProperties().get("humantask"));
    return notifier.subscribeOn(bundle.getRioga().getConfiguration().getProperties().get("humantask")+"Subscriber", new QName("http://www.gind.emac.fr/HumanTaskTopic", "addHumanTaskTopic"));
  }


  protected void assertRunAsyncResponse(GJaxbRunASyncResponse res) {
    assert true;
  }

  @Override
  protected RIOSuiteAbstractBundle initBundle() throws Exception {
    return new RIOSuiteSimulationAndOrchestrationBundle();
  }


  protected void assertError(GJaxbErrorReport res) {
      Assertions.assertNotNull(res);
  }


  public GJaxbProcessStatusType doTestOrchestrate(
      RIOSuiteDeductionTest ucDeductionTest,
      AbstractDeductionStrategy strategyDeduction, Map<String, Entry<String, String>> humanAnswers, GJaxbProcessStatusType processStatusExpected) throws Exception {

    /* launch publish/deploy/instance of process */
      bundle.getRioga().getUserResource();
      DWUser user = new DWUser(SystemResource.getDEFAULT_ADMIN(), bundle.getRioga().getUserResource().getSystemClient());
    File existingDeducedProcess = new File(new File("target"), getProcessFileNameFromStrategy(strategyDeduction));
    GJaxbRunASyncResponse res = launchOrchestrationTest(user, existingDeducedProcess, ucDeductionTest, strategyDeduction, humanAnswers);
    LOG.debug("PROCESS INSTANCE ID " + res.getInstanceId());


    /* Get process instance id to retrieve its status    */
    GJaxbGetProcessInstanceResponse processInstance = bundle.getRioga().getResourcesManager().findResource(ProcessResource.class).processInstance(user, res.getInstanceId());
    while(processInstance == null || processInstance.getInstanceInfo() == null) {
      LOG.debug("PROCESS INSTANCE IS NULL");
      Thread.sleep(2000);
      processInstance = bundle.getRioga().getResourcesManager().findResource(ProcessResource.class).processInstance(user, res.getInstanceId());
    }
    GJaxbProcessStatusType currentProcessStatus = processInstance.getInstanceInfo().getStatus();



    /* while the process is not ended and not crashed  we execute remaining human tasks */
    while(!currentProcessStatus.equals(processStatusExpected) && !currentProcessStatus.equals(GJaxbProcessStatusType.CRASHED)  && !currentProcessStatus.equals(GJaxbProcessStatusType.ENDED)) {
      /* check for process status update*/
      processInstance = bundle.getRioga().getResourcesManager().findResource(ProcessResource.class).processInstance(user, res.getInstanceId());
      currentProcessStatus = processInstance.getInstanceInfo().getStatus();
      LOG.debug("PROCESS STATUS " + currentProcessStatus);
      Thread.sleep(5000);
    }
    LOG.debug("process final status " + currentProcessStatus);
    return currentProcessStatus;
  }
}
