/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: josepe
 */
package fr.emac.gind.usecases.riosuite.test;

/*
 * #%L
 * workflow-engine-prk
 * %%
 * Copyright (C) 2014 - 2015 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.util.List;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class Scenario {

  private List<String> risks = null;
  private List<String> preventiveStrategies = null;
  private List<String> correctiveStrategies = null;
  private Double expectedDuration = null;
  private Double expectedCost = null;
  private Double expectedProbability = null;
  private String name = "";

  public Scenario(List<String> risks, List<String> preventiveStrategies, List<String> correctiveStrategies, Double expectedDuration, Double expectedCost, Double expectedProbability) {
    this(risks, preventiveStrategies, correctiveStrategies, null, expectedDuration, expectedCost, expectedProbability);
  }
  
  public Scenario(List<String> risks, List<String> preventiveStrategies, List<String> correctiveStrategies, String impedanceStrategy, Double expectedDuration, Double expectedCost, Double expectedProbability) {
    this.risks = risks;
    this.preventiveStrategies = preventiveStrategies;
    this.correctiveStrategies = correctiveStrategies;
    this.expectedDuration = expectedDuration;
    this.expectedCost = expectedCost;
    this.expectedProbability = expectedProbability;

    final StringBuffer title = new StringBuffer();
    if(!risks.isEmpty()) {
      risks.forEach(risk -> { title.append(risk + ", "); });
      title.delete(title.length() - ", ".length(), title.length());
    }
    title.append("/");
    if(!preventiveStrategies.isEmpty()) {
      preventiveStrategies.forEach(preventiveStrategy -> { title.append(preventiveStrategy + ", "); });
      title.delete(title.length() - ", ".length(), title.length());
    }
    title.append("/");
    if(!correctiveStrategies.isEmpty()) {
      correctiveStrategies.forEach(correctiveStrategy -> { title.append(correctiveStrategy + ", "); });
      title.delete(title.length() - ", ".length(), title.length());
    }
    this.name = title.toString();
  }

  public String getName() {
    return name;
  }

  public List<String> getRisks() {
    return risks;
  }

  public List<String> getPreventiveStrategies() {
    return preventiveStrategies;
  }

  public List<String> getCorrectiveStrategies() {
    return correctiveStrategies;
  }

  public Double getExpectedDuration() {
    return expectedDuration;
  }

  public Double getExpectedCost() {
    return expectedCost;
  }

  public Double getExpectedProbability() {
    return expectedProbability;
  }


}
