/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: josepe
 */
package fr.emac.gind.usecases.riosuite.test.partners;

/*
 * #%L
 * workflow-engine
 * %%
 * Copyright (C) 2014 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.net.URI;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;

import fr.emac.gind.commons.utils.uri.URIHelper;
import fr.emac.gind.workflow.engine.partners.PartnerEvaluator;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class PartnerEvaluatorTest implements PartnerEvaluator {


	public String getAddress(Element partner) {
		String addr = partner.getTextContent();
		URI uri = URI.create(addr);
		
		return URIHelper.getParamsInQuery(uri).get("address");
	}

	public QName getServiceName(Element partner) {
		String addr = partner.getTextContent();
		URI uri = URI.create(addr);
		
		String serviceName = URIHelper.getParamsInQuery(uri).get("service");
		String serviceNs = uri.toString().replace("?" + uri.getQuery(), "");
		return new QName(serviceNs, serviceName);
	}

	public String getEndpointName(Element partner) {
		String addr = partner.getTextContent();
		URI uri = URI.create(addr);
		
		return URIHelper.getParamsInQuery(uri).get("endpoint");
	}

	public void setEndpointName(Element partner, String newEndpoint) {
		String addr = partner.getTextContent();
		URI uri = URI.create(addr);
		
		throw new RuntimeException("Not Implementd!!!");
	}

	

}
