/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.usecases.riosuite.test;

import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.rio.PluginCollaborativeModel;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.rio.dw.resources.gov.bo.DeduceInput;
import fr.emac.gind.rio.suite.test.RIOSuiteDeductionBundle;
import fr.emac.gind.usecases.RIOAbstractProject;
import fr.emac.gind.usecases.riosuite.test.RIOSuiteTest;
import fr.emac.gind.workflow.deduction.AbstractDeductionStrategy;
import fr.emac.gind.workflow.deduction.SimpleSatisfactionStrategyDeductionCampaign;
import fr.emac.gind.workflow.report.GJaxbDeductionReport;
import fr.emac.gind.workflow.report.GJaxbErrorReport;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public abstract class RIOSuiteDeductionTest
extends RIOSuiteTest {
    private static final Logger LOG = LoggerFactory.getLogger((String)RIOSuiteDeductionTest.class.getName());

    public RIOSuiteDeductionTest(RIOAbstractProject uc) throws Exception {
        super(uc);
    }

    public RIOSuiteDeductionTest initialize() {
        return this;
    }

    public String getStrategy() {
        String ordering = null;
        JSONObject deduction = (JSONObject)this.uc.getContext().get("deductionStrategy");
        if (deduction != null) {
            ordering = deduction.getString("priorityOrder");
        }
        return ordering;
    }

    protected void validProcessesWithBasicAssertion(GJaxbDeductionReport report) throws Exception {
        Assertions.assertNotNull((Object)report, (String)"No reports");
        Assertions.assertNotNull((Object)report.getGenericModel());
    }

    private void assertProcess(AbstractDeductionStrategy strategy) throws Exception {
        DeduceInput request = this.generateStrategyRequest(strategy);
        GJaxbGenericModel process = null;
        if (strategy.getName().equals(new SimpleSatisfactionStrategyDeductionCampaign().getName())) {
            process = this.doGenerateProcess_usingSatisfactionStrategy(request);
        }
        if (process != null) {
            LOG.debug("global assertion");
            Assertions.assertTrue((boolean)process.getNode().stream().anyMatch(n -> {
                try {
                    return EffectiveMetaModelPluginManager.getInstance().inherit(n, new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Task"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }));
            LOG.debug("save file to earn time");
            this.generateProcessFile(strategy, process);
        }
    }

    @Override
    protected RIOSuiteAbstractBundle initBundle() throws Exception {
        return new RIOSuiteDeductionBundle();
    }

    protected void assertError(GJaxbErrorReport res) {
        Assertions.assertNotNull((Object)res);
    }

    @Test
    public void generateProcess_usingSatisfactionStrategy() throws Exception {
        this.assertProcess((AbstractDeductionStrategy)new SimpleSatisfactionStrategyDeductionCampaign());
    }

    public abstract GJaxbGenericModel doGenerateProcess_usingSatisfactionStrategy(DeduceInput var1) throws Exception;
}

