/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.usecases.riosuite.test;

import fr.emac.gind.bootstrap.test.GindTest;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.system_gov.SystemGov;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.neo4j.GJaxbQuery;
import fr.emac.gind.neo4j.GJaxbQueryResponse;
import fr.emac.gind.neo4j.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.processgeneratorinstance.GJaxbProcessGeneratorInstance;
import fr.emac.gind.rio.bundle.RIOSuiteAbstractBundle;
import fr.emac.gind.rio.bundle.config.ConfigurationUnifier;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.rio.dw.resources.gov.Neo4JResource;
import fr.emac.gind.rio.dw.resources.gov.ProjectResource;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.rio.dw.resources.gov.bo.DeduceInput;
import fr.emac.gind.usecase.GJaxbModelURLType;
import fr.emac.gind.usecase.GJaxbResourceType;
import fr.emac.gind.usecases.RIOAbstractProject;
import fr.emac.gind.workflow.deduction.AbstractDeductionStrategy;
import fr.emac.gind.workflow.engine.WorkflowContainer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.w3c.dom.Node;

public abstract class RIOSuiteTest
extends GindTest {
    protected RIOAbstractProject uc = null;
    protected Map<String, URL> results = new HashMap<String, URL>();
    protected static RIOSuiteAbstractBundle bundle = null;
    protected static ModelsResource modelsResource = null;
    public static final String FAKE_NO_TEST_MODEL = "fakeNoTestModel";

    public RIOSuiteTest(RIOAbstractProject uc) throws Exception {
        Configuration.CONFIG_PATH = "./target/";
        this.uc = uc;
    }

    @BeforeEach
    public void setup() throws Exception {
        FileUtil.deleteDirectory((File)new File("./target/questdb_data"));
        FileUtil.deleteDirectory((File)new File("./target/usecases"));
        FileUtil.deleteDirectory((File)new File("./target/mongo-db"));
        FileUtil.deleteDirectory((File)new File("./target/influxdb_data"));
        FileUtil.deleteDirectory((File)new File("./target/neo4j-db"));
        SystemResource.setCURRENT_USER(null);
        SystemResource.setDEFAULT_ADMIN(null);
        bundle = this.initBundle();
        this.modifyUsecaseForSpecificCase(this.uc);
        this.runBundleAndLoadUsecases();
        LOG.debug("STARTING UNIT TEST !!!");
    }

    protected void modifyUsecaseForSpecificCase(RIOAbstractProject uc) throws MalformedURLException, Exception {
    }

    protected abstract RIOSuiteAbstractBundle initBundle() throws Exception;

    @AfterEach
    public void tearDown() throws Exception {
        LOG.debug("STOPPING UNIT TEST !!!");
        if (bundle != null && bundle.getRioga() != null) {
            GJaxbNode user = bundle.getRioga().getApplicationContext().getCurrentUser();
            DWUser dwUser = new DWUser(user, bundle.getRioga().getUserResource().getSystemClient());
            GJaxbQuery query = new GJaxbQuery();
            query.setQuery("MATCH (n) DETACH DELETE n");
            GJaxbSelectedKnowledgeSpace ck = new GJaxbSelectedKnowledgeSpace();
            ck.setCollaborationName(dwUser.getCurrentCollaborationName());
            ck.setKnowledgeName(dwUser.getCurrentKnowledgeSpaceName());
            query.setSelectedKnowledgeSpace(ck);
            try {
                GJaxbQueryResponse response = ((Neo4JResource)bundle.getRioga().getResourcesManager().findResource(Neo4JResource.class)).query(dwUser, query);
                LOG.debug("clear neo4j database ... " + response.getJsonResponse());
            }
            catch (Throwable e) {
                LOG.warn("Neo4J already stopped", e);
            }
        }
        if (bundle != null) {
            bundle.stop();
        }
    }

    public void runBundleAndLoadUsecases() throws Exception {
        Configuration suiteConfig = ConfigurationUnifier.unify((RIOSuiteAbstractBundle)bundle);
        Configuration conf = new Configuration(Thread.currentThread().getContextClassLoader().getResource("conf/generated/workflow-container/conf/config.properties").toURI().toURL());
        conf.getProperties().replace("repository", "./target/repository");
        suiteConfig.setVersion("1.0-SNAPSHOT");
        bundle.setSpecificConfigurationOfSubComponents(WorkflowContainer.class, conf);
        bundle.boot(suiteConfig);
        bundle.run();
        modelsResource = (ModelsResource)bundle.getRioga().getResourcesManager().findResource(ModelsResource.class);
        bundle.getRioga().getUserResource();
        bundle.getRioga().getApplicationContext().setCurrentUser(SystemResource.getDEFAULT_ADMIN());
        DWUser user = new DWUser(bundle.getRioga().getApplicationContext().getCurrentUser(), bundle.getRioga().getUserResource().getSystemClient());
        if (((CoreResource)bundle.getRioga().getResourcesManager().findResource(CoreResource.class)).findNodesByTypesAndOrProperties(user, List.of(new QName("http://fr.emac.gind/system", "User")), null, List.of("ACTIVE"), null, null).isEmpty()) {
            LOG.debug("resetting user ...");
            bundle.getRioga().getUserResource();
            ((CoreResource)bundle.getRioga().getResourcesManager().findResource(CoreResource.class)).addNode(user, SystemResource.getDEFAULT_ADMIN());
        }
        LOG.debug("loading usecase " + this.uc.getUsecaseDef().getName() + " by " + user.getName() + "  " + user.getCurrentCollaborationName() + " " + user.getCurrentKnowledgeSpaceName());
        String collaborationName = user.getCurrentCollaborationName();
        String knowledgeSpaceName = RegExpHelper.toRegexFriendlyName((String)this.uc.getUsecaseDef().getName());
        GJaxbNode collab = null;
        List collabs = ((ProjectResource)bundle.getRioga().getResourcesManager().findResource(ProjectResource.class)).getSystem().findCollaborationsByName(user, collaborationName);
        collab = collabs.isEmpty() ? SystemResource.createCollaboration((String)collaborationName, (SystemGov)((ProjectResource)bundle.getRioga().getResourcesManager().findResource(ProjectResource.class)).getSystem().getSystemClient(), (GJaxbEffectiveConceptType)((ProjectResource)bundle.getRioga().getResourcesManager().findResource(ProjectResource.class)).getSystem().getCollaborationMetaModel()) : (GJaxbNode)collabs.get(0);
        ((ProjectResource)bundle.getRioga().getResourcesManager().findResource(ProjectResource.class)).getSystem().selectCollaboration(user, collab.getId(), collab.getId());
        ((ProjectResource)bundle.getRioga().getResourcesManager().findResource(ProjectResource.class)).loadProject(this.uc, collaborationName, knowledgeSpaceName, user, false, false, new ArrayList(), false);
        if (!this.uc.findResourceByName("objectives", GJaxbResourceType.MODEL).isSelected()) {
            GJaxbModelURLType objRsc = (GJaxbModelURLType)this.uc.findResourceByName("objectives", GJaxbResourceType.MODEL);
            ArrayList<GJaxbModelURLType> modelsByUrlSelected = new ArrayList<GJaxbModelURLType>();
            GJaxbModelURLType model = new GJaxbModelURLType();
            model.setName(objRsc.getName());
            model.setUrl(objRsc.getUrl());
            model.setStatus(objRsc.getStatus());
            model.setCategory(objRsc.getCategory());
            modelsByUrlSelected.add(model);
            Optional<DWUser> userOpt = Optional.of(user);
            modelsResource.addModelsFromURL(userOpt, modelsByUrlSelected);
        }
    }

    protected List<GJaxbNode> retrieveNodesFromKnowledge(String queryString, String view, DWUser user) throws Exception {
        GJaxbGenericModel response = modelsResource.query(user, queryString, view);
        if (response != null && response.getNode() != null && response.getNode() != null) {
            return response.getNode();
        }
        return List.of();
    }

    protected JSONArray retrieveNodesFromKnowledgeAsJSONArray(String queryString, String view, DWUser user) throws Exception {
        List<GJaxbNode> nodes = this.retrieveNodesFromKnowledge(queryString, view, user);
        JSONArray valueArray = new JSONArray();
        nodes.forEach(n -> {
            try {
                JSONObject o = new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(n)).getJSONObject("node");
                String id = o.getString("id");
                if (id.contains("_c__")) {
                    id = id.split("_c__")[0];
                }
                o.put("id", (Object)id);
                valueArray.put((Object)o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return valueArray;
    }

    protected JSONArray retrievePropertiesOfNodesFromKnowledge(String queryString, String view, DWUser user) throws Exception {
        List<GJaxbNode> nodes = this.retrieveNodesFromKnowledge(queryString, view, user);
        JSONArray valueArray = new JSONArray();
        nodes.forEach(n -> {
            try {
                JSONArray o = new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(n)).getJSONObject("node").getJSONArray("property");
                String id = n.getId();
                if (id.contains("_c__")) {
                    id = id.split("_c__")[0];
                }
                JSONObject idObject = new JSONObject();
                idObject.put("name", (Object)"id");
                idObject.put("value", (Object)id);
                o.put((Object)idObject);
                valueArray.put((Object)o);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return valueArray;
    }

    protected DeduceInput generateStrategyRequest(AbstractDeductionStrategy strategy) throws Exception {
        DeduceInput res = new DeduceInput();
        GJaxbProcessGeneratorInstance processGeneration = new GJaxbProcessGeneratorInstance();
        processGeneration.setClazz(strategy.getClass().getCanonicalName());
        processGeneration.setName(strategy.getName());
        String pg = JSONJAXBContext.getInstance().marshallAnyElement((Object)processGeneration);
        JSONObject o = new JSONObject(pg);
        res.setProcessGeneratorInstance(o.getJSONObject("processGeneratorInstance").toString());
        return res;
    }

    protected void generateProcessFile(AbstractDeductionStrategy strategy, GJaxbGenericModel process) throws Exception {
        File processFile = new File(new File("target"), this.getProcessFileNameFromStrategy(strategy));
        if (!processFile.exists()) {
            LOG.debug("deduced process file does not exist, creating it ");
            processFile.createNewFile();
        }
        LOG.debug("deduced process file " + processFile.getAbsolutePath());
        FileUtil.setContents((File)processFile, (String)XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)process)));
        URL processURL = processFile.toURI().toURL();
    }

    protected String getProcessFileNameFromStrategy(AbstractDeductionStrategy strategy) {
        return "processDeduced_" + strategy.getName().trim() + ".xml";
    }
}

