/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Sebastien REBIERE
 */
package fr.emac.gind.usecases.iosuite.shared.resources.context.albi;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.junit.jupiter.api.Test;

import fr.emac.gind.models.generic.modeler.utils.checker.ModelAnomaly;
import fr.emac.gind.models.generic.modeler.utils.checker.ModelChecker;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class RIOUCSharedResourcesContextAlbiTest {


  @Test
  public void checkModel() throws Exception {
	  ModelChecker checker = new ModelChecker();
	  Map<File, List<ModelAnomaly>> anomalies = checker.checkDirectory(new File("./src/main/resources/" + "META-INF/resources/webjars/gind/usecases/reference_crisis_commons_roles" + "/models"));

	  if(!anomalies.isEmpty()) {
		  for(Entry<File, List<ModelAnomaly>> entry: anomalies.entrySet()) {
			  System.out.println("Error on file: " + entry.getKey().getName() + "\n");
			  for(ModelAnomaly anomaly: entry.getValue()) {
				  System.out.println(anomaly.printAnomalyMessage());
			  }
		  }
		  
		  checker.repairAllAnomalies(anomalies);
	  }
  }


}
