/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application;

import org.json.JSONObject;

import fr.emac.gind.application.model.GJaxbApplication;
import fr.emac.gind.gov.ai.chatbot.service.builder.ModelBuilderSelector;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;

public class ApplicationContext {

	protected GJaxbApplication application = null;
	protected GJaxbEffectiveMetaModel core = null;
	protected GJaxbEffectiveMetaModel project = null;
	protected GJaxbEffectiveMetaModel system = null;
	protected GJaxbEffectiveMetaModel uml = null;

	private String additional_logo = null;
	private String mainColor = null;

	protected DWApplicationService applicationService = null;

	private GJaxbNode currentUser = null;

	private JSONObject allWebApplications = new JSONObject();

	public ApplicationContext(DWApplicationService applicationService) {
		this.applicationService = applicationService;
	}

	public GJaxbApplication getApplication() {
		return application;
	}

	public void setApplication(GJaxbApplication application) {
		this.application = application;
	}

	public JSONObject getAllWebApplications() {
		return allWebApplications;
	}

	public void setAllWebApplications(JSONObject allWebApplications) {
		this.allWebApplications = allWebApplications;
	}
	
	public GJaxbEffectiveMetaModel getCore() {
		return core;
	}

	public void setCore(GJaxbEffectiveMetaModel core) {
		this.core = core;
	}

	public GJaxbEffectiveMetaModel getProject() {
		return project;
	}

	public void setProject(GJaxbEffectiveMetaModel project) {
		this.project = project;
	}

	public GJaxbEffectiveMetaModel getSystem() {
		return system;
	}

	public void setSystem(GJaxbEffectiveMetaModel system) {
		this.system = system;
	}

	public GJaxbEffectiveMetaModel getUml() {
		return uml;
	}

	public void setUml(GJaxbEffectiveMetaModel uml) {
		this.uml = uml;
	}

	public GJaxbNode getCurrentUser() {
		return currentUser;
	}

	public void setCurrentUser(GJaxbNode currentUser) {
		this.currentUser = currentUser;
	}

	public String getAdditional_logo() {
		return additional_logo;
	}

	public void setAdditional_logo(String additional_logo) {
		this.additional_logo = additional_logo;
	}

	public String getMainColor() {
		return mainColor;
	}

	public void setMainColor(String mainColor) {
		this.mainColor = mainColor;
	}

	public JSONObject toJSON() throws Exception {
		JSONObject json = new JSONObject();
		json.put("application", new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(application)));
		json.put("core", new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(core)));
		json.put("project", new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(project)));
		json.put("system", new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(system)));
		json.put("uml", new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(uml)));
		json.put("allWebApplications", allWebApplications);

		json.put("redirection", this.applicationService.getRedirection());
		json.put("version", this.applicationService.getConfiguration().getProperties().get("version"));
		json.put("proxy-port", this.applicationService.getConfiguration().getProperties().get("proxy-port"));
		json.put("generationDate", this.applicationService.getConfiguration().getProperties().get("generation-date"));
		json.put("tools_r-iopiot", this.applicationService.getConfiguration().getProperties().get("tools_r-iopiot"));


		if (currentUser != null) {
			json.put("currentUser", new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(currentUser)));
			this.currentUser = null;
		}

		if (this.mainColor != null) {
			json.put("additional_mainColor", mainColor);
		}
		if (this.additional_logo != null) {
			json.put("additional_logo", additional_logo);
		}

		if (System.getenv("GOOGLE_API_KEY") != null) {
			json.put("GOOGLE_API_KEY", System.getenv("GOOGLE_API_KEY"));
		}
		if (System.getenv("UNSPLASH_ACCESS_KEY") != null) {
			json.put("UNSPLASH_ACCESS_KEY", System.getenv("UNSPLASH_ACCESS_KEY"));
		}
		if (System.getenv("FULLCALENDAR_LICENSE_KEY") != null) {
			json.put("FULLCALENDAR_LICENSE_KEY", System.getenv("FULLCALENDAR_LICENSE_KEY"));
		}
		json.put("exisingChatModels", ModelBuilderSelector.getInstance().existingChatModels());
		json.put("exisingImageAnalysisChatModels",
				ModelBuilderSelector.getInstance().existingImageAnalysisChatModels());
		json.put("exisingImageCreationModels", ModelBuilderSelector.getInstance().existingImageCreationModels());
		return json;
	}

}
