/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application;

import java.io.IOException;
import java.util.Iterator;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;

import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;

public class GJaxbSerialierModule extends SimpleModule {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;


  public GJaxbSerialierModule() {
    addDeserializer(GJaxbGenericModel.class, new GJaxbGenericModelDeserializer());
    addSerializer(GJaxbGenericModel.class, new GJaxbGenericModelSerializer());
  }

  public class GJaxbGenericModelSerializer extends JsonSerializer<GJaxbGenericModel> {
    @Override
    public void serialize(GJaxbGenericModel value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
      try {
        jgen.writeStartObject();
        jgen.writeStringField("node", JSONJAXBContext.getInstance().marshallAnyElement(value.getNode()));
        jgen.writeStringField("edge", JSONJAXBContext.getInstance().marshallAnyElement(value.getEdge()));
        jgen.writeEndObject();
      } catch(Exception e) {
        throw new IOException(e.getMessage(), e);
      }
    }
  }


  public class GJaxbGenericModelDeserializer extends JsonDeserializer<GJaxbGenericModel> {
    @Override
    public GJaxbGenericModel deserialize(final JsonParser jp, final DeserializationContext ctxt) throws IOException, JsonProcessingException {
      GJaxbGenericModel model = new GJaxbGenericModel();
      try {
        JsonNode jsonModel = jp.getCodec().readTree(jp);

        Iterator<JsonNode> nodes = jsonModel.get("node").elements();
        while(nodes.hasNext()) {
          JsonNode node = nodes.next();
          model.getNode().add(JSONJAXBContext.getInstance().unmarshall(node.asText(), GJaxbNode.class));
        }

        Iterator<JsonNode> edges = jsonModel.get("edge").elements();
        while(edges.hasNext()) {
          JsonNode edge = edges.next();
          model.getEdge().add(JSONJAXBContext.getInstance().unmarshall(edge.asText(), GJaxbEdge.class));
        }
      } catch(Exception e) {
        throw new IOException(e.getMessage(), e);
      }
      return model;
    }
  }
}
