/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2016 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.lang.reflect.Method;

import org.apache.commons.lang3.exception.ExceptionUtils;

import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Response.Status;

public class GindWebApplicationException extends WebApplicationException {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  private GindWebApplicationException(Exception e, Status status, Method method) {
    super(Response.status(status)
        .entity(createGindError(e, status, method))
        .type(MediaType.APPLICATION_JSON)
        .build());
    e.printStackTrace();
  }
  
  private static GindError createGindError(Exception e, Status status, Method method) {
    GindError error = new GindError();

    error.setMessage(e.getMessage());
    error.setStackTrace(ExceptionUtils.getStackTrace(e));
    error.setMethod(method.getName());
    error.setClazz(method.getDeclaringClass().getName());
    error.setStatus(String.valueOf(status.getStatusCode()));
    error.setStatusMessage(status.toString());
    return error;
  }
  
  

  public static void manageError(Exception e, Object currentMethod) throws Exception {
    if(e instanceof GindWebApplicationException) {
      throw e;
    } else {
      throw new GindWebApplicationException(e, Response.Status.INTERNAL_SERVER_ERROR, ReflectionHelper.getCurrentMethod(currentMethod));
    }
  }


}
