/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application;

import java.util.Map;

import javax.xml.namespace.QName;

import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.json_connector.GJaxbSensorEvent;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;

@WebService(serviceName = "NotifierClientService", portName = "NotifierClientEndpoint", targetNamespace = "http://www.gind.emac.fr/notifier", wsdlLocation = "/wsdl/notifier.wsdl", endpointInterface = "fr.emac.gind.notifier.NotifierClient")
public class RIODataSourceSensorNotifierClient extends AbstractNotifierClient {

	private static Logger LOG = LoggerFactory.getLogger(RIODataSourceSensorNotifierClient.class.getName());

	private WebsocketCommand WEB_SOCKET_COMMAND = null;

	public RIODataSourceSensorNotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND) throws Exception {
		super(address);
		this.WEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
	}

	@Override
	public synchronized void notify(GJaxbNotify notify) {
		try {

			Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);

			String address = notify.getNotificationMessage().get(0).getProducerReference().getAddress().getValue();
			String queryPath = address.replace("http://", "");
			LOG.debug("log event receive from: " + address);

			Map<QName, Element> mapInfo = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
			JSONObject json = new JSONObject();
			
			Object payload = null;
			if(doc.getDocumentElement().getLocalName().equals("sensorEvent")) {
				GJaxbSensorEvent sensorEvent = XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbSensorEvent.class);
				payload = new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement(sensorEvent));
			} else {
				payload = XMLCompactPrinter.print(doc.getDocumentElement());
			}
			
			json.put("log", payload);
			json.put("createAt", mapInfo.get(new QName("http://www.gind.emac.fr", "createAt")).getTextContent());
			json.put("sendAt", mapInfo.get(new QName("http://www.gind.emac.fr", "sendAt")).getTextContent());
			json.put("eventId", mapInfo.get(new QName("http://www.gind.emac.fr", "eventId")).getTextContent());

			if (mapInfo.get(new QName("http://www.gind.emac.fr", "context")) != null) {
				Element elmtContext = mapInfo.get(new QName("http://www.gind.emac.fr", "context"));
				Element elmtEventIndex = DOMUtil.getInstance().findFirstElementByNs(elmtContext,
						new QName("http://www.gind.emac.fr", "eventIndex"));
				if (elmtEventIndex != null) {
					json.put("eventIndex", Integer.parseInt(elmtEventIndex.getTextContent()));
				}
			}

			GJaxbGetResult request = new GJaxbGetResult();
			request.setWebsocketId(queryPath);
			request.setJsonResult(json.toString());

			WEB_SOCKET_COMMAND.getResult(request);
		} catch (Exception e) {
			LOG.warn(e.getMessage(), e);
		}
	}

}
