/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.humantask.GJaxbAddHumanTaskEvent;
import fr.emac.gind.humantask.GJaxbRemoveHumanTaskEvent;
import fr.emac.gind.humantask.GJaxbTask;
import fr.emac.gind.humantask.GJaxbUpdateHumanTaskEvent;
import fr.emac.gind.marshaller.JSONJAXBContext;
import fr.emac.gind.marshaller.XMLJAXBContext;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;

@WebService(serviceName = "NotifierClientService", portName = "NotifierClientEndpoint", targetNamespace = "http://www.gind.emac.fr/notifier", wsdlLocation = "/wsdl/notifier.wsdl", endpointInterface = "fr.emac.gind.notifier.NotifierClient")
public class RIOHumanTaskNotifierClient extends AbstractNotifierClient {

	private static final Logger LOG = LoggerFactory.getLogger(RIOHumanTaskNotifierClient.class.getName());

	private WebsocketCommand WEB_SOCKET_COMMAND = null;
	private String name = null;

	public RIOHumanTaskNotifierClient(String address, WebsocketCommand WEB_SOCKET_COMMAND, String name)
			throws Exception {
		super(address);
		this.WEB_SOCKET_COMMAND = WEB_SOCKET_COMMAND;
		this.name = name;
	}

	@Override
	public void notify(GJaxbNotify notify) {
		try {

			String collaborationName = null;
			String knowledgeName = null;

			GJaxbTask ht = null;
			Document msg = WSNHelper.getInstance().getFirstMessageInNotification(notify);
			Object event = null;
			if (msg.getDocumentElement().getLocalName().equals("addHumanTaskEvent")
					&& msg.getDocumentElement().getNamespaceURI().equals("http://www.gind.emac.fr/humantask")) {
				GJaxbAddHumanTaskEvent me = XMLJAXBContext.getInstance().unmarshallDocument(msg,
						GJaxbAddHumanTaskEvent.class);
				ht = me.getTask();
				collaborationName = me.getCollaborationName();
				knowledgeName = me.getKnowledgeSpaceName();
				event = me;
			} else if (msg.getDocumentElement().getLocalName().equals("updateHumanTaskEvent")
					&& msg.getDocumentElement().getNamespaceURI().equals("http://www.gind.emac.fr/humantask")) {
				GJaxbUpdateHumanTaskEvent me = XMLJAXBContext.getInstance().unmarshallDocument(msg,
						GJaxbUpdateHumanTaskEvent.class);
				ht = me.getTask();
				collaborationName = me.getCollaborationName();
				knowledgeName = me.getKnowledgeSpaceName();
				event = me;
			} else if (msg.getDocumentElement().getLocalName().equals("removeHumanTaskEvent")
					&& msg.getDocumentElement().getNamespaceURI().equals("http://www.gind.emac.fr/humantask")) {
				GJaxbRemoveHumanTaskEvent me = XMLJAXBContext.getInstance().unmarshallDocument(msg,
						GJaxbRemoveHumanTaskEvent.class);
				ht = me.getTask();
				collaborationName = me.getCollaborationName();
				knowledgeName = me.getKnowledgeSpaceName();
				event = me;
			}

			if (collaborationName == null) {
				throw new Exception("CollaborationName cannot be null !!!");
			}
			if (knowledgeName == null) {
				throw new Exception("knowledgeName cannot be null !!!");
			}

			GJaxbGetResult result = new GJaxbGetResult();
			result.setJsonResult(JSONJAXBContext.getInstance().marshallAnyElement(event));
			
			// For ALL  - For Admin
			result.setWebsocketId("/rioga" + "/" + RegExpHelper.toRegexFriendlyName(collaborationName)
					+ "/" + RegExpHelper.toRegexFriendlyName(knowledgeName) + "/" + this.name
					+ "/humantask/");
			WEB_SOCKET_COMMAND.getResult(result);
			
			
			for (String personId : ht.getAssignedToIds()) {
				// By Person  For User 
				result.setWebsocketId("/rioga" + "/" + RegExpHelper.toRegexFriendlyName(collaborationName)
						+ "/" + RegExpHelper.toRegexFriendlyName(knowledgeName) + "/" + this.name
						+ "/humantask/" + personId);
				
				
				WEB_SOCKET_COMMAND.getResult(result);
			}

			

		} catch (Exception e) {
			e.printStackTrace();
			LOG.warn(e.getMessage(), e);
		}
	}

}
