/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;

import jakarta.ws.rs.WebApplicationException;

/**
*
*
* @author Nicolas Salatge
*/
public class RestWebApplicationException extends WebApplicationException {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  public RestWebApplicationException(Throwable cause) {
    super(generateJSONFaultMessage(cause).toString(), cause);
  }

  private static JSONObject generateJSONFaultMessage(Throwable cause) {
    JSONObject fault = new JSONObject();
    fault.put("Fault", new JSONObject());
    fault.getJSONObject("Fault").put("message", cause.getMessage());
    fault.getJSONObject("Fault").put("stacktrace", ExceptionUtils.getStackTrace(cause));
    return fault;
  }
  
  
  

}
