/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.auth;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.system_gov.GJaxbFindUserByLoginAndPassword;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;

/*
 * #%L
 * dw-users
 * %%
 * Copyright (C) 2014 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */



import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.basic.BasicCredentials;



/**
 *
 *
 * @author Nicolas Salatge
 */
public class BasicAuthenticator implements Authenticator<BasicCredentials, DWUser> {

  private static Logger LOG = LoggerFactory.getLogger(BasicAuthenticator.class.getName()); 

  private SystemResource system = null;


  public BasicAuthenticator(SystemResource system) {
    this.system = system;
  }

  @Override
  public Optional<DWUser> authenticate(BasicCredentials credentials) throws AuthenticationException {
    try {
      String login = credentials.getUsername();
      String password = credentials.getPassword();
      GJaxbFindUserByLoginAndPassword req = new GJaxbFindUserByLoginAndPassword();
      req.setLogin(login);
      req.setPassword(password);
      GJaxbNode user = system.getSystemClient().findUserByLoginAndPassword(req).getNode();
      if(user == null) {
        throw new AuthenticationException("Login and/or password are invalid !!!");
      }


      LOG.debug("Authentification successfully!!!");
      return Optional.of(new DWUser(user, this.system.getSystemClient()));

    } catch (Exception e) {
      e.printStackTrace();
      LOG.error(e.getMessage(), e);
      if(!e.getClass().getName().equals(AuthenticationException.class.getName())) {
        throw new AuthenticationException(e.getMessage(), e);
      } else {
        throw (AuthenticationException)e;
      }
    }
  }
}
