/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.bundles.modifier;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import fr.emac.gind.generic.application.bundles.AbstractModifierResource;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class BootstrapCSSModifierResource extends AbstractModifierResource {


	private String bgMenu      = null;
	private String bgMenuFocus = null;
	private String fontColor = null;
	private String fontColorFocus = null;

	public BootstrapCSSModifierResource(String bgMenu, String bgMenuFocus, String fontColor, String fontColorFocus) {
		super("/webjars/gind/generic/application/stylesheets/navbar.css");
		this.bgMenu = bgMenu;
		this.bgMenuFocus = bgMenuFocus;
		this.fontColor = fontColor;
		this.fontColorFocus = fontColorFocus;
	}

	@Override
	public byte[] replace(String url, byte[] buffer) {
		String newBuffer = new String(buffer);
		if(bgMenu != null && !bgMenu.trim().isEmpty()) {
		  if(bgMenu.contains("#333")) {
		    newBuffer = newBuffer.replace("#333", "#FFFFFF");
		  }
			newBuffer = newBuffer.replace("#F8F8F8", bgMenu);
		}
		if(bgMenuFocus != null && !bgMenuFocus.trim().isEmpty()) {
			newBuffer = newBuffer.replace("#E7E7E7", bgMenuFocus).replace("#D5D5D5", bgMenuFocus);
		}
		if(fontColor != null && !fontColor.trim().isEmpty()) {
			newBuffer = newBuffer.replace("#777", fontColor);
		}
		if(fontColorFocus != null && !fontColorFocus.trim().isEmpty()) {
      newBuffer = newBuffer.replace("#555", fontColorFocus);
    }
		return newBuffer.getBytes();
	}

  @Override
  public boolean accept(String requestedResourceURL) {
    return requestedResourceURL.toString().endsWith(this.getResourcePatterns().get(0));
  }

}
