/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.configuration;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 - 2017 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import net.sourceforge.argparse4j.inf.Namespace;

public abstract class EnvironmentCommandWithoutLog<T extends Configuration> extends ConfiguredCommandWithoutLog<T> {
  private final Application<T> application;

  /**
   * Creates a new environment command.
   *
   * @param application     the application providing this command
   * @param name        the name of the command, used for command line invocation
   * @param description a description of the command's purpose
   */
  protected EnvironmentCommandWithoutLog(Application<T> application, String name, String description) {
    super(name, description);
    this.application = application;
  }

  @Override
  protected void run(Bootstrap<T> bootstrap, Namespace namespace, T configuration) throws Exception {
    final Environment environment = new Environment(bootstrap.getApplication().getName(),
        bootstrap.getObjectMapper(),
        bootstrap.getValidatorFactory(),
        bootstrap.getMetricRegistry(),
        bootstrap.getClassLoader(),
        bootstrap.getHealthCheckRegistry(),
        configuration);
    
    

    configuration.getMetricsFactory().configure(environment.lifecycle(),
        bootstrap.getMetricRegistry());
    configuration.getServerFactory().configure(environment);

    try {
      bootstrap.run(configuration, environment);
      application.run(configuration, environment);
      run(environment, namespace, configuration);
    } catch(Throwable e) {
      e.printStackTrace();
      throw new RuntimeException(e.getMessage(), e);
    }
  }

  /**
   * Runs the command with the given {@link Environment} and {@link Configuration}.
   *
   * @param environment   the configured environment
   * @param namespace     the parsed command line namespace
   * @param configuration the configuration object
   * @throws Exception if something goes wrong
   */
  protected abstract void run(Environment environment, Namespace namespace, T configuration) throws Exception;
}
