/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
package fr.emac.gind.generic.application.launcher;

/*
 * #%L
 * dw-generic-application
 * %%
 * Copyright (C) 2014 EMAC - Gind
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.launcher.Main;
import fr.emac.gind.storage.launcher.EventStorageLauncher;
import fr.emac.gind.storage.mongodb.launcher.StorageLauncher;

/**
 *
 *
 * @author Nicolas Salatge
 */
public class GenericApplicationLauncher extends AbstractLauncher {
	
  static {
    Main.addLauncherToIgnore(StorageLauncher.class);
    Main.addLauncherToIgnore(EventStorageLauncher.class);
  }
	
	private ServiceLoader<DWApplicationService> genericApplicationLoader = ServiceLoader.load(DWApplicationService.class);
	private List<DWApplicationService> genericApplications = new ArrayList<DWApplicationService>();

	
	private DWApplicationService runner = null;
	
	public GenericApplicationLauncher() throws Exception {

	}
	
	@Override
	public String getInfo() {
		StringBuffer res = new StringBuffer();
		return res.toString();
	}

	@Override
	public String getName() {
		if(runner != null && runner.getApplication() != null) {
			return runner.getApplication().getTitle();
		}
		return "Gind Generic Application";
	}

	@Override
	public String getPromptName() {
		return "app";
	}

	@Override
	public void startRunner(final Configuration conf) throws Exception {
	   // Discover and register the available commands
    genericApplications.clear();
    genericApplicationLoader.reload();
    Iterator<DWApplicationService> applicationsIterator = genericApplicationLoader.iterator();
    while (applicationsIterator.hasNext()) {
      DWApplicationService appService = applicationsIterator.next();
      
      genericApplications.add(appService);
    }
    
    
    if(genericApplications.isEmpty()) {
      throw new Exception("No service found");
    }
    if(genericApplications.size() > 1) {
      throw new Exception("Too much services found: " + genericApplications);
    }
    
    runner = genericApplications.get(0);
    
    

		runner.boot(conf);
		runner.run(new String[]{ "server", new File(runner.getYmlConfig().toURI()).getCanonicalFile().toString() });

		

		if(Desktop.isDesktopSupported()) {
			if(Desktop.getDesktop().isSupported(java.awt.Desktop.Action.BROWSE)) {
				java.awt.Desktop.getDesktop().browse(new URI("http://" + runner.getConfiguration().getHost() + ":" + runner.getConfiguration().getPort() + "/" + runner.getName()  + runner.getShortPath()));
			}
		}
	}

  @Override
  public void stopRunner() throws Exception {
    runner.stop();
  }


}
